Summary: GNU CSSC - An SCCS clone
Name: CSSC
Version: 0.14alpha.pl0
Release: 1
URL: http://cssc.sourceforge.net/
Copyright: GPL (one program is BSD, see COPYING.bsd)
Packager: James Youngman <jay@gnu.org>
Group: Development/Version Control
Source: ftp://alpha.gnu.org/pub/gnu/CSSC/CSSC-%{PACKAGE_VERSION}.tar.gz
Prereq: /sbin/install-info
Requires: /usr/bin/diff

# You must set BuildRoot to a previously nonexistent directory,
# because we start by doing "rm -rf $RPM_BUILD_ROOT"!
BuildRoot: /var/tmp/cssc-root

%description
CSSC is a clone for the traditional Unix version control suite SCCS.
It aims for near-total compatibility with SCCS.  CSSC stands for
"Compatibly Stupid Source Control".  

%prep
%setup

%build
if test x"$RPM_BUILD_ROOT" = x/
then
    cat >&2 <<EOF
\$RPM_BUILD_ROOT is $RPM_BUILD_ROOT.   
Did you do something unwise with the --buildroot option?
EOF
    exit 1
fi
if test -d $RPM_BUILD_ROOT
then
	echo "Build root directory $RPM_BUILD_ROOT already exists" >&2
	echo "I'm too scared to delete (rm -rf) it." >&2
	exit 1
fi
rm -rf $RPM_BUILD_ROOT
rm -f docs/cssc.info
./configure --prefix=/usr --enable-binary
make

%install
make prefix=$RPM_BUILD_ROOT/usr install-strip
# [ -L /usr/sccs ] && rm -f /usr/sccs
ln -s libexec/cssc $RPM_BUILD_ROOT/usr/sccs
cd $RPM_BUILD_ROOT/usr/bin 
ln -s ../libexec/cssc/* .

%post
/sbin/install-info /usr/info/cssc.info /usr/info/dir

%preun
if [ $1 = 0 ]; then
    /sbin/install-info --delete /usr/info/cssc.info /usr/info/dir
fi

%clean
rm -rf $RPM_BUILD_ROOT



%changelog

* Sat Jul 14 2001 James Youngman <jay@gnu.org>
Pass the --enable-binary flag to enable binary file support.
This was previously the default, but it is now mandatory to 
supply the option (or --disable-binary).

* Tue Jul 18 2000 James Youngman <jay@gnu.org>
Updated URL.

* Mon Jun 15 1998 Aron Griffis <agriffis@coat.com>
Added symbolic links in /usr/bin to call programs directly

* Wed Jun 10 1998 jay@gnu.org <James Youngman>
Added sccs.1 to the list of files.

* Sat May 23 1998 interran@crd.GE.COM <John Interrante>
Don't use --infodir since that breaks the BuildRoot.  "--infodir" is
set by setting "--prefix" anyway.

* Fri May  8 1998 interran@crd.GE.COM <John Interrante>
Use a build-root.   Also use install-info.  Use install-strip 
rather than just "strip *".

* Sat Feb 21 1998 jay@gnu.org <James Youngman>
Strip the installed binaries.

* Thu Feb 12 1998 jay@gnu.org <James Youngman>
Added sccsdiff to the file list.

* Sat Jan 17 1998 jay@gnu.org <James Youngman>

First RPMed version (0.05alpha-pl0)

%files
%attr(-, root, root) %doc README AUTHORS COPYING ChangeLog INSTALL NEWS 
%attr(-, root, root) %doc docs/BUGS docs/CREDITS docs/FIXED docs/Platforms 
%attr(-, root, root) %doc docs/TESTING docs/TODO docs/missing.txt 
%attr(-, root, root) %doc docs/patches.txt docs/mailing-list.txt
%attr(-, root, root) %doc docs/style.txt
%attr(-, root, root) %doc bsd/COPYING.bsd bsd/sccs.me
%attr(-, root, root) %doc /usr/info/cssc.info*
%attr(755, root, root) /usr/libexec/cssc
%attr(-, root, root) /usr/sccs
%attr(-, root, root) /usr/bin/sccs
%attr(-, root, root) /usr/man/man1/sccs.1
