/*
 *  declarations for unit-test utilities for cryptmoumt
 *  $Revision: 130 $, $Date: 2006-10-15 11:42:36 +0100 (Sun, 15 Oct 2006) $
 *  Copyright 2006, RW Penney
 */

/*
    This file is part of cryptmount

    cryptmount is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    As a special exemption, permission is granted to link cryptmount
    with the OpenSSL project's "OpenSSL" library and distribute
    the linked code without invoking clause 2(b) of the GNU GPL version 2.

    cryptmount is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with cryptmount; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */


#ifndef _CMTEST_H
#define _CMTEST_H

#include <config.h>


extern int cm_tests_run, cm_tests_stat[];
extern const char *cm_test_ident;

enum {
    CM_TEST_PASSED = 0,
    CM_TEST_FAILED,
    CM_TEST_ABORTED,
    CM_TEST_LAST
};


#define CM_TEST_START(name) \
    { \
        fprintf(stderr, "starting test %s...", name); \
        ++cm_tests_run; \
        cm_test_ident = NULL; \
    }

#define CM_TEST_IDENT(ident) \
    { \
        cm_test_ident = (const char*)ident; \
    }

#define CM_ASSERT_EQUAL(expected,actual) \
    if ((expected) != (actual)) { \
        fprintf(stderr, "  test failed %s:%d\n", __FILE__, __LINE__); \
        if (cm_test_ident != NULL) { \
            fprintf(stderr, "    [%s]\n", cm_test_ident); } \
        ++cm_tests_stat[CM_TEST_FAILED]; \
        return CM_TEST_FAILED; \
    }

#define CM_ASSERT_DIFFERENT(expected,actual) \
    if ((expected) == (actual)) { \
        fprintf(stderr, "  test failed %s:%d\n", __FILE__, __LINE__); \
        if (cm_test_ident != NULL) { \
            fprintf(stderr, "    [%s]\n", cm_test_ident); } \
        ++cm_tests_stat[CM_TEST_FAILED]; \
        return CM_TEST_FAILED; \
    }

#define CM_TEST_OK() \
    { \
        fprintf(stderr, " ok\n"); \
        ++cm_tests_stat[CM_TEST_PASSED]; \
        return CM_TEST_PASSED; \
    }

#define CM_TEST_FAIL() \
    { \
        fprintf(stderr, " FAILED\n"); \
        if (cm_test_ident != NULL) { \
            fprintf(stderr, "    [%s]\n", cm_test_ident); } \
        ++cm_tests_stat[CM_TEST_FAILED]; \
        return CM_TEST_FAILED; \
    }

#define CM_TEST_ABORT() \
    { \
        fprintf(stderr, " ABORTED\n"); \
        if (cm_test_ident != NULL) { \
            fprintf(stderr, "    [%s]\n", cm_test_ident); } \
        ++cm_tests_stat[CM_TEST_ABORTED]; \
        return CM_TEST_ABORTED; \
    }


int cm_run_tests();


#endif  /* _CMTEST_H */

/*
 *  (C)Copyright 2006, RW Penney
 */
