#include "cp_types.h"

/* Various "time" routines; intention is to measure user's cpu 
   time for speed comparisons. */

long get_time()
{
  struct rusage RU;

  getrusage(RUSAGE_SELF,&RU);
  return RU.ru_utime.tv_sec;
} /* get_time */

int time_to_hms(long elapsetime,int *hr,int *min,int *sec)
{
  *hr=(int)floor((double)elapsetime/3600.0);
  *min=(int)floor((double)(elapsetime-(*hr)*3600.0)/60.0);
  *sec=(int)(elapsetime-(*hr)*3600.0-(*min)*60.0);
  return 1;
} /* time_to_hms */

