/* routines to convert drawing action requests from circle packing
   into appropriate Xlib calls. */
/* Note: gc is the standard graphics contex, gc_fill is one for
   filled objects */

#include "cp_types.h"
#include "cp_proto.h"

extern Display *display;
extern GC gc,gc_fill;
extern unsigned long fgcolor;

int SetForeground(unsigned long color,int fflag)
     /* fflag = 0 for gc, 1 for gc_fill */
{
  if (fflag)
    XSetForeground(display,gc_fill,color);
  else 
    XSetForeground(display,gc,color);
  return 1;
} /* SetForeground */

int DrawLines(Drawable xpm,XPoint *points,int npoints,
	      unsigned long color)
{
  XSetForeground(display,gc,color);
  XDrawLines(display,xpm,gc,points,npoints,CoordModeOrigin);
  XSetForeground(display,gc,fgcolor);
  return 1;
} /* DrawLines */

int DrawLine(Drawable xpm,int x1,int y1,int x2,int y2,
	     unsigned long color)
{
  XSetForeground(display,gc,color);
  XDrawLine(display,xpm,gc,x1,y1,x2,y2);
  XSetForeground(display,gc,fgcolor);
  return 1;
} /* DrawLine */

int DrawArc(Drawable xpm,int x,int y,
	    unsigned int width,unsigned int height,
	    int angle1,int angle2,
	    unsigned long color)
{
  XSetForeground(display,gc,color);
  XDrawArc(display,xpm,gc,x,y,width,height,angle1,angle2);
  XSetForeground(display,gc,fgcolor);
  return 1;
} /* DrawArc */

int DrawString(Drawable xpm,int x,int y,char *text,int length)
{
  XDrawString(display,xpm,gc,x,y,text,length);
  return 1;
} /* DrawString */

int FillRectangle(Drawable xpm,int x,int y,
		  unsigned int width,unsigned int height)
{
  XFillRectangle(display,xpm,gc,x,y,width,height);
  return 1;
} /* FillRectangle */

int FillArc(Drawable xpm,int x,int y,
	    unsigned int width,unsigned int height,
	    int angle1,int angle2,
	    unsigned long color,int fflag)
     /* fflag = 0 for gc, 1 for gc_fill */
{
  if (fflag) 
    {
      XSetForeground(display,gc_fill,color);
      XFillArc(display,xpm,gc_fill,x,y,width,height,angle1,angle2);
      XSetForeground(display,gc_fill,fgcolor);
    }
  else
    {
      XSetForeground(display,gc,color);
      XFillArc(display,xpm,gc,x,y,width,height,angle1,angle2);
      XSetForeground(display,gc,fgcolor);
    }
  return 1;
} /* FillArc */

int FillPolygon(Drawable xpm,XPoint *points,int npoints,
		unsigned long color)
/* set foreground color of gc_fill, draw filled polygon, then reset
   color */
{
  XSetForeground(display,gc_fill,color);
  XFillPolygon(display,xpm,gc_fill,points,npoints,
	       Nonconvex,CoordModeOrigin);
  XSetForeground(display,gc_fill,fgcolor);
  return 1;
} /* FillPolygon */

int Flush()
{
  XFlush(display);
  return 1;
} /* Flush */
