/*
 * main.c
 *
 * Copyright (C) 2003 Bastian Blank <waldi@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $LastChangedBy: bastian $
 * $LastChangedDate: 2006-10-20 15:26:44 +0000 (Fr, 20 Okt 2006) $
 * $LastChangedRevision: 1275 $
 */

#include <config.h>

#include <signal.h>
#include <stdlib.h>

#include "frontend.h"
#include "install.h"

void cleanup_atexit (void)
{
  install_umount ();
}

void cleanup_signal (int signum __attribute__ ((unused)))
{
  install_umount ();
  log_text (DI_LOG_LEVEL_WARNING, "got signal");
  exit (1);
}

int main (int argc, char **argv, char **envp)
{
  atexit (cleanup_atexit);
  signal (SIGHUP, cleanup_signal);
  signal (SIGINT, cleanup_signal);
  signal (SIGPIPE, cleanup_signal);
  signal (SIGTERM, cleanup_signal);

  if (frontend_main (argc, argv, envp))
    log_text (DI_LOG_LEVEL_ERROR, "frontend died");
  return 0;
}

