;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Eval/library.scm             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jun 23 15:31:39 2005                          */
;*    Last change :  Tue Jun 20 18:11:40 2006 (serrano)                */
;*    Copyright   :  2005-06 Manuel Serrano                            */
;*    -------------------------------------------------------------    */
;*    The library-load facility                                        */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __library
   
   (import __error
	   __thread
	   __type
	   __bigloo
	   __configure
	   __param
	   __eval
	   __r5_control_features_6_4
	   __everror)
   
   (use     __tvector
	    __bexit
	    __os
	    __foreign
	    __evenv
	    
	    __r4_numbers_6_5_fixnum
	    __r4_numbers_6_5_flonum
	    __r4_booleans_6_1
	    __r4_symbols_6_4
	    __r4_vectors_6_8
	    __r4_control_features_6_9
	    __r4_pairs_and_lists_6_3
	    __r4_characters_6_6
	    __r4_equivalence_6_2
	    __r4_strings_6_7
	    __r4_ports_6_10_1
	    __r4_ports_6_10_1
	    __r4_output_6_10_3
	    __r4_input_6_10_2)

   (export  (library-translation-table::pair-nil)
	    (library-translation-table-add! ::symbol ::bstring . ::obj)
	    (library-file-name::bstring ::symbol ::bstring ::symbol)
	    (library-load ::obj . opt)))

;*---------------------------------------------------------------------*/
;*    *transtable-mutex* ...                                           */
;*---------------------------------------------------------------------*/
(define *transtable-mutex* (make-mutex 'library))

;*---------------------------------------------------------------------*/
;*    *library-transtable* ...                                         */
;*---------------------------------------------------------------------*/
(define *library-transtable* '())

;*---------------------------------------------------------------------*/
;*    library-translation-table ...                                    */
;*---------------------------------------------------------------------*/
(define (library-translation-table)
   *library-transtable*)

;*---------------------------------------------------------------------*/
;*    library-translation-table-add! ...                               */
;*---------------------------------------------------------------------*/
(define (library-translation-table-add! name translation . opt)
   (let ((version (if (pair? opt)
		      (car opt)
		      (bigloo-config 'release-number))))
      (mutex-lock! *transtable-mutex*)
      (set! *library-transtable*
	    (cons (cons name (cons translation version)) *library-transtable*))
      (mutex-unlock! *transtable-mutex*)))

;*---------------------------------------------------------------------*/
;*    library-init-file ...                                            */
;*---------------------------------------------------------------------*/
(define (library-init-file lib)
   (string-append (symbol->string lib) ".init"))

;*---------------------------------------------------------------------*/
;*    untranslate-library-name ...                                     */
;*---------------------------------------------------------------------*/
(define (untranslate-library-name library::symbol)
   (let ((trans (assq library (library-translation-table))))
      (if (pair? trans)
	  (values (cadr trans) (cddr trans))
	  (values (symbol->string library) (bigloo-config 'release-number)))))
   
;*---------------------------------------------------------------------*/
;*    library-file-name ...                                            */
;*---------------------------------------------------------------------*/
(define (library-file-name library suffix backend)
   (define (forge-name base suffix version)
      (cond
	 ((not version)
	  (string-append base suffix))
	 ((string? version)
	  (string-append base suffix "-" version))
	 (else
	  (error 'library-file-name "Illegal version" version))))
   (multiple-value-bind (base version)
      (untranslate-library-name library)
      (case backend
	 ((bigloo-c)
	  (cond
	     ((or (string=? (os-class) "unix")
		  (string=? (os-class) "mingw"))
	      (forge-name base suffix version))
	     ((string=? (os-class) "win32")   
	      (string-append base suffix))
	     (else
	      (error 'library-file-name "Unknown os" (os-class)))))
	 ((bigloo-jvm)
	  (forge-name base suffix version))
	 ((bigloo-.net)
	  (forge-name base suffix version))
	 (else
	  (error 'library-file-name "Illegal backend" backend)))))

;*---------------------------------------------------------------------*/
;*    library-load ...                                                 */
;*---------------------------------------------------------------------*/
(define (library-load lib . path)
   (if (string? lib)
       (dynamic-load lib)
       (let* ((path (if (pair? path)
			path
			(let ((venv (getenv "BIGLOOLIB")))
			   (if (not venv)
			       (bigloo-library-path)
			       (cons "." (unix-path->list venv))))))
	      (init (find-file/path (library-init-file lib) path))
	      (be (cond-expand
		     (bigloo-c 'bigloo-c)
		     (bigloo-jvm 'bigloo-jvm)
		     (bigloo-.net 'bigloo.net))))
	  (when init (loadq init))
	  (let* ((n (make-shared-lib-name (library-file-name lib "" be) be))
		 (ns (make-shared-lib-name (library-file-name lib "_s" be) be))
		 (ne (make-shared-lib-name (library-file-name lib "_e" be) be))
		 (lib (let ((p (string-append "/resource/" n)))
			 ;; jvm supports fake file system in the JAR file.
			 ;; in Bigloo is is a sub-directory of /resource
			 (and (file-exists? p) p)))
		 (libs (find-file/path ns path))
		 (libe (find-file/path ne path)))
	     (cond
		((and (not (string? lib)) (not (string? libs)))
		 (error 'library-load
			(format "Can't find library `~a' (`~a')" lib ns)
			path))
		((not (string? libe))
		 (evmeaning-warning
		  #f
		  'library-load
		  (format "Can't find _e library `~a' (`~a') in path "
			  lib ne)
		  path)
		 (if (string? libs)
		     (dynamic-load libs)
		     (dynamic-load lib)))
		(else
		 (if (string? libs)
		     (dynamic-load libs)
		     (dynamic-load lib))
		 (dynamic-load libe)))))))




















