package bigloo;

import java.io.*;

public class input_file_port extends input_port {
    public RandomAccessFile in;

    public input_file_port(byte[] file, int size)
	throws IOException {
	super(new String(file), size); 
	in = new RandomAccessFile(new String(file),"r");
    }

    public void close() throws IOException {
	eof = true;
	other_eof = true;
	in.close();
    }

    public boolean rgc_charready() {
	if (eof || other_eof) return false;

	try{ 
	    return ((forward+1) < abufsiz) || 
		(in.getFilePointer() < in.length());
	} catch( Exception _ ) {
	    return false;
	}
    }

    public boolean rgc_fill_buffer() throws IOException {
	int bufsize    = this.bufsiz;
	int abufsize   = this.abufsiz;
	int matchstart = this.matchstart;
	byte[] buffer = this.buffer;
	if(matchstart > 0) {
	    int movesize = abufsize - matchstart;
	    // we shift the buffer left and we fill the buffer */
	    for(int i=0; i<movesize; i++) buffer[i] = buffer[matchstart + i];
	    abufsize       -= matchstart;
	    this.matchstart = 0;
	    this.matchstop -= matchstart;
	    this.forward   -= matchstart;
	    this.lastchar   = buffer[ matchstart - 1 ];
	    return(rgc_size_fill_file_buffer(abufsize, bufsize - abufsize));
	}
	if(abufsize < bufsize)
	    return(rgc_size_fill_file_buffer(abufsize, bufsize - abufsize));
	// we current token is too large for the buffer */
	// we have to enlarge it.                       */
	rgc_enlarge_buffer();
	return(rgc_fill_buffer());
    }

    final boolean rgc_size_fill_file_buffer(int abufsize, int size)
	throws IOException {
	int nbread = in.read(buffer, abufsize-1, size);
	if(nbread == -1) {
	    nbread = 0;
	    eof = true;
	}
	abufsize += nbread;
	this.abufsiz = abufsize;
	if(abufsize > 0) {
	    buffer[abufsize - 1] = (byte) 0;
	    return(true);
	}
	return(false);
    }

    Object bgl_input_port_seek(int pos) throws IOException {
	in.seek( pos );

	filepos = pos;
	eof = false;
	matchstart = 0;
	matchstop = 0;
	forward = 0;
	abufsiz = 1;
	lastchar = (byte)'\n';
	buffer[0] = 0;

	return(bigloo.foreign.BTRUE);
    }

    Object bgl_input_port_reopen() throws IOException {
	in.close();
	in = new RandomAccessFile(name,"r");

	filepos = 0;
	eof = false;
	matchstart = 0;
	matchstop = 0;
	forward = 0;
	abufsiz = 1;
	lastchar = (byte)'\n';
	buffer[0] = 0;

	return(bigloo.foreign.BTRUE);
    }

    public void write(output_port p) {
	p.write( "#<input_file_port:" + name + ">" );
    }
}
