/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime/Jlib/client_socket.java      */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Tue Dec  5 10:53:03 2000                          */
/*    Last change :  Sat Jul 14 06:49:33 2001 (serrano)                */
/*    Copyright   :  2000-01 Manuel Serrano                            */
/*    -------------------------------------------------------------    */
/*    The Client Socket implementation for the JVM back-end.           */
/*=====================================================================*/
package bigloo;
import bigloo.*;
import java.io.*;
import java.net.*;

/*---------------------------------------------------------------------*/
/*    SOCKET ...                                                       */
/*---------------------------------------------------------------------*/
public class client_socket extends socket {
/*--- public fields ---------------------------------------------------*/
    Socket socket;

/*--- constructors ----------------------------------------------------*/
    public client_socket( client_socket s ) {
    }

    // This is a client socket creation
    public client_socket( byte[] hostname, int port, boolean b ) {
	super();

	try {
	    socket = new Socket( new String(hostname), port );
	    set_socket_io_ports( (Socket)socket, b );
	} 
	catch ( UnknownHostException e ) {
	    socket_error( "make-client-socket",
			  "unknown or misspelled host name",
			  hostname );
	}
	catch( IOException e ) {
	    socket_error( "make-client-socket",
			  "cannot create socket",
			  hostname );
	}
    }

/*--- public methods --------------------------------------------------*/
    public byte[] HOSTNAME() {
	return socket.getInetAddress().getHostName().getBytes();
    }

    public byte[] HOSTIP() {
	return socket.getInetAddress().getAddress();
    }
   
    public byte[] local_addr() {
	return socket.getLocalAddress().getAddress();
    }

    public Object shutdown(boolean close_socket) throws IOException {
	socket.close();
	down = true;
	return bigloo.foreign.BUNSPEC;
    }

    public int PORT() {
	return socket.getPort();
    }
}
