;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Ieee/number.scm              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Mar 24 09:59:43 1995                          */
;*    Last change :  Tue Jun 26 06:04:38 2001 (serrano)                */
;*    -------------------------------------------------------------    */
;*    6.5. Numbers (page 18, r4)                                       */
;*    -------------------------------------------------------------    */
;*    Source documentation:                                            */
;*       @path ../../manuals/body.texi@                                */
;*       @node Numbers@                                                */
;*=====================================================================*/
 
;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __r4_numbers_6_5
   
   (import  __error)

   (use     __type
	    __bigloo
	    __tvector
	    __r4_equivalence_6_2
	    __r4_numbers_6_5_fixnum
	    __r4_booleans_6_1
	    __r4_characters_6_6
	    __r4_pairs_and_lists_6_3
	    __r4_vectors_6_8
	    __r4_numbers_6_5_flonum
	    __r4_symbols_6_4
	    __r4_strings_6_7

	    __evenv)
   
   (extern  (macro c-fixnum->flonum::double (::long)   "(double)")
	    (macro c-flonum->fixnum::long   (::double) "(long)")
	    (export exact->inexact "bgl_exact_to_inexact")
	    (export inexact->exact "bgl_inexact_to_exact"))
   
   (java    (class foreign
	       (method static c-fixnum->flonum::double (::long)
		       "FIXNUM_TO_FLONUM")
	       (method static c-flonum->fixnum::long   (::double)
		       "FLONUM_TO_FIXNUM")))
   
   (export  (inline number?::bool           obj)
	    (inline exact?::bool            z)
	    (inline inexact?::bool          z)
	    (complex?::bool                 x)
	    (rational?::bool                x)
	    (inline flonum->fixnum::long    ::double)
	    (inline fixnum->flonum::double  ::long)
	    (2=::bool                       x y)
	    (=::bool                        x y . z)
	    (2<::bool                       x y) 
	    (<::bool                        x y . z)
	    (2>::bool                       x y)
	    (>::bool                        x y . z)
	    (2<=::bool                      x y)
	    (<=::bool                       x y . z)
	    (2>=::bool                      x y)
	    (>=::bool                       x y . z)
	    (zero?::bool                    x)
	    (positive?::bool                x)
	    (negative?::bool                x)
	    (max                            x . y)
	    (min                            x . y)
	    (2+                             x y)
	    (+                              . x)
	    (2*                             x y)
	    (*                              . x)
	    (2-                             x y)
	    (-                              x . y)
	    (2/                             x y)
	    (/                              x . y)
	    (abs                            x)
	    (floor                          x)
	    (ceiling                        x)
	    (truncate                       x)
	    (round                          x)
	    (exp::double                    x) 
	    (log::double                    x) 
	    (sin::double                    x) 
	    (cos::double                    x) 
	    (tan::double                    x) 
	    (asin::double                   x) 
	    (acos::double                   x) 
	    (atan::double                   x . y) 
	    (sqrt::double                   x) 
	    (expt                           x y)
	    (inline exact->inexact          z)
	    (inline inexact->exact          z)
	    (number->string::string         x . radix)
	    (string->number                 x . radix))

   (pragma  (2= side-effect-free)
	    (= side-effect-free)
	    (2< side-effect-free)
	    (< side-effect-free)
	    (2> side-effect-free)
	    (> side-effect-free)
	    (2<= side-effect-free)
	    (<= side-effect-free)
	    (2>= side-effect-free)
	    (>= side-effect-free)
	    (zero? side-effect-free)
	    (positive? side-effect-free)
	    (negative? side-effect-free)
	    (max side-effect-free)
	    (min side-effect-free)
	    (2+ side-effect-free)
	    (+ side-effect-free)
	    (2* side-effect-free)
	    (* side-effect-free)
	    (2/ side-effect-free)
	    (/ side-effect-free)
	    (2- side-effect-free)
	    (- side-effect-free)
	    (abs side-effect-free)
	    (floor side-effect-free)
	    (ceiling side-effect-free)
	    (truncate side-effect-free)
	    (round side-effect-free)
	    (exp side-effect-free)
	    (log side-effect-free)
	    (sin side-effect-free)
	    (cos side-effect-free)
	    (tan side-effect-free)
	    (asin side-effect-free)
	    (acos side-effect-free)
	    (atan side-effect-free)
	    (sqrt side-effect-free)
	    (expt side-effect-free)
	    (exact->inexact side-effect-free)
	    (inexact->exact side-effect-free)
	    (number->string side-effect-free)
	    (string->number side-effect-free)))

;*---------------------------------------------------------------------*/
;*    number? ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (number? obj)
   (if (fixnum? obj)
       #t
       (flonum? obj)))

;*---------------------------------------------------------------------*/
;*    exact? ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (exact? z)
   (integer? z))

;*---------------------------------------------------------------------*/
;*    inexact? ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (inexact? z)
   (flonum? z))

;*---------------------------------------------------------------------*/
;*    complex? ...                                                     */
;*---------------------------------------------------------------------*/
(define (complex? x)
   (number? x))

;*---------------------------------------------------------------------*/
;*    rational? ...                                                    */
;*---------------------------------------------------------------------*/
(define (rational? x)
   (real? x))

;*---------------------------------------------------------------------*/
;*    flonum->fixnum ...                                               */
;*---------------------------------------------------------------------*/
(define-inline (flonum->fixnum x)
   (c-flonum->fixnum x))

;*---------------------------------------------------------------------*/
;*    fixnum->flonum ...                                               */
;*---------------------------------------------------------------------*/
(define-inline (fixnum->flonum x)
   (c-fixnum->flonum x))
		       
;*---------------------------------------------------------------------*/
;*    2= ...                                                           */
;*---------------------------------------------------------------------*/
(define (2= x y)
   (cond
      ((fixnum? x)
       (cond
	  ((fixnum? y)
	   (=fx x y))
	  ((flonum? y)
	   (=fl (fixnum->flonum x) y))
	  (else
	   (error "=" "not a number" y))))
      ((flonum? x)
       (cond
	  ((flonum? y)
	   (=fl x y))
	  ((fixnum? y)
	   (=fl x (fixnum->flonum y)))
	  (else
	   (error "=" "not a number" y))))
      (else
       (error "=" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    = ...                                                            */
;*---------------------------------------------------------------------*/
(define (= x y . z)
   (define (=-list x z)
	    (cond
	       ((null? z) #t)
	       ((2= x (car z))
		(=-list x (cdr z)))
	       (else #f)))
   (and (2= x y)
	(=-list y z)))

;*---------------------------------------------------------------------*/
;*    2< ...                                                           */
;*---------------------------------------------------------------------*/
(define (2< x y)
   (cond
      ((fixnum? x)
       (cond
	  ((fixnum? y)
	   (<fx x y))
	  ((flonum? y)
	   (<fl (fixnum->flonum x) y))
	  (else
	   (error "<" "not a number" y))))
      ((flonum? x)
       (cond
	  ((flonum? y)
	   (<fl x y))
	  ((fixnum? y)
	   (<fl x (fixnum->flonum y)))
	  (else
	   (error "<" "not a number" y))))
      (else
       (error "<" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    < ...                                                            */
;*---------------------------------------------------------------------*/
(define (< x y . z)
   (define (<-list x z)
	    (cond
	       ((null? z) #t)
	       ((2< x (car z))
		(<-list (car z) (cdr z)))
	       (else #f)))
   (and (2< x y)
	(<-list y z)))

   
;*---------------------------------------------------------------------*/
;*    2> ...                                                           */
;*---------------------------------------------------------------------*/
(define (2> x y)
   (cond
      ((fixnum? x)
       (cond
	  ((fixnum? y)
	   (>fx x y))
	  ((flonum? y)
	   (>fl (fixnum->flonum x) y))
	  (else
	   (error ">" "not a number" y))))
      ((flonum? x)
       (cond
	  ((flonum? y)
	   (>fl x y))
	  ((fixnum? y)
	   (>fl x (fixnum->flonum y)))
	  (else
	   (error ">" "not a number" y))))
      (else
       (error ">" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    > ...                                                            */
;*---------------------------------------------------------------------*/
(define (> x y . z)
   (define (>-list x z)
	    (cond
	       ((null? z) #t)
	       ((2> x (car z))
		(>-list (car z) (cdr z)))
	       (else #f)))
   (and (2> x y)
	(>-list y z)))
 
;*---------------------------------------------------------------------*/
;*    2<= ...                                                          */
;*---------------------------------------------------------------------*/
(define (2<= x y)
   (cond
      ((fixnum? x)
       (cond
	  ((fixnum? y)
	   (<=fx x y))
	  ((flonum? y)
	   (<=fl (fixnum->flonum x) y))
	  (else
	   (error "<=" "not a number" y))))
      ((flonum? x)
       (cond
	  ((flonum? y)
	   (<=fl x y))
	  ((fixnum? y)
	   (<=fl x (fixnum->flonum y)))
	  (else
	   (error "<=" "not a number" y))))
      (else
       (error "<=" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    <= ...                                                           */
;*---------------------------------------------------------------------*/
(define (<= x y . z)
   (define (<=-list x z)
      (cond
	 ((null? z) #t)
	 ((2<= x (car z))
	  (<=-list (car z) (cdr z)))
	 (else #f)))
   (and (2<= x y)
	(<=-list y z)))

;*---------------------------------------------------------------------*/
;*    2>= ...                                                          */
;*---------------------------------------------------------------------*/
(define (2>= x y)
   (cond
      ((fixnum? x)
       (cond
	  ((fixnum? y)
	   (>=fx x y))
	  ((flonum? y)
	   (>=fl (fixnum->flonum x) y))
	  (else
	   (error ">=" "not a number" y))))
      ((flonum? x)
       (cond
	  ((flonum? y)
	   (>=fl x y))
	  ((fixnum? y)
	   (>=fl x (fixnum->flonum y)))
	  (else
	   (error ">=" "not a number" y))))
      (else
       (error ">=" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    >= ...                                                           */
;*---------------------------------------------------------------------*/
(define (>= x y . z)
   (define (>=-list x z)
	    (cond
	       ((null? z) #t)
	       ((2>= x (car z))
		(>=-list (car z) (cdr z)))
	       (else #f)))
   (and (2>= x y)
	(>=-list y z)))

;*---------------------------------------------------------------------*/
;*    zero? ...                                                        */
;*---------------------------------------------------------------------*/
(define (zero? x)
   (cond
      ((fixnum? x)
       (zerofx? x))
      ((flonum? x)
       (zerofl? x))
      (else
       (error "zero" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    positive? ...                                                    */
;*---------------------------------------------------------------------*/
(define (positive? x)
   (cond
      ((fixnum? x)
       (positivefx? x))
      ((flonum? x)
       (positivefl? x))
      (else
       (error "positive" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    negative? ...                                                    */
;*---------------------------------------------------------------------*/
(define (negative? x)
   (cond
      ((fixnum? x)
       (negativefx? x))
      ((flonum? x)
       (negativefl? x))
      (else
       (error "negative" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    max ...                                                          */
;*---------------------------------------------------------------------*/
(define (max x . y)
   (let loop ((x x)
	      (y y))
      (if (pair? y)
	  (loop (if (> x (car y))
		    x
		    (car y))
		(cdr y))
	  x)))

;*---------------------------------------------------------------------*/
;*    min ...                                                          */
;*---------------------------------------------------------------------*/
(define (min x . y)
   (let loop ((x x)
	      (y y))
      (if (pair? y)
	  (loop (if (< x (car y))
		    x
		    (car y))
		(cdr y))
	  x)))

;*---------------------------------------------------------------------*/
;*    2+ ...                                                           */
;*---------------------------------------------------------------------*/
(define (2+ x y)
   (cond
      ((fixnum? x)
       (cond
	  ((fixnum? y)
	   (+fx x y))
	  ((flonum? y)
	   (+fl (fixnum->flonum x) y))
	  (else
	   (error "+" "not a number" y))))
      ((flonum? x)
       (cond
	  ((flonum? y)
	   (+fl x y))
	  ((fixnum? y)
	   (+fl x (fixnum->flonum y)))
	  (else
	   (error "+" "not a number" y))))
      (else
       (error "+" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    + ...                                                            */
;*---------------------------------------------------------------------*/
(define (+  . x)
   (let loop ((sum 0)
	      (x x))
      (if (pair? x)
	  (loop (2+ sum (car x))
		(cdr x))
	  sum)))

;*---------------------------------------------------------------------*/
;*    2* ...                                                           */
;*---------------------------------------------------------------------*/
(define (2* x y)
   (cond
      ((fixnum? x)
       (cond
	  ((fixnum? y)
	   (*fx x y))
	  ((flonum? y)
	   (*fl (fixnum->flonum x) y))
	  (else
	   (error "*" "not a number" y))))
      ((flonum? x)
       (cond
	  ((flonum? y)
	   (*fl x y))
	  ((fixnum? y)
	   (*fl x (fixnum->flonum y)))
	  (else
	   (error "*" "not a number" y))))
      (else
       (error "*" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    * ...                                                            */
;*---------------------------------------------------------------------*/
(define (*  . x)
   (let loop ((product 1)
	      (x x))
      (if (pair? x)
	  (loop (2* product (car x)) (cdr x))
	  product)))

;*---------------------------------------------------------------------*/
;*    2- ...                                                           */
;*---------------------------------------------------------------------*/
(define (2- x y)
   (cond
      ((fixnum? x)
       (cond
	  ((fixnum? y)
	   (-fx x y))
	  ((flonum? y)
	   (-fl (fixnum->flonum x) y))
	  (else
	   (error "-" "not a number" y))))
      ((flonum? x)
       (cond
	  ((flonum? y)
	   (-fl x y))
	  ((fixnum? y)
	   (-fl x (fixnum->flonum y)))
	  (else
	   (error "-" "not a number" y))))
      (else
       (error "-" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    - ...                                                            */
;*---------------------------------------------------------------------*/
(define (- x . y)
    (if (pair? y)
	(let loop ((result (2- x (car y)))
		   (args (cdr y)))
	   (if (pair? args)
	       (loop (2- result (car args)) (cdr args))
	       result))
	(2- 0 x)))

;*---------------------------------------------------------------------*/
;*    2/ ...                                                           */
;*---------------------------------------------------------------------*/
(define (2/ x y)
   (cond
      ((fixnum? x)
       (cond
	  ((fixnum? y)
	   (if (=fx (remainder x y) 0)
	       (/fx x y)
	       (/fl (fixnum->flonum x) (fixnum->flonum y))))
	  ((flonum? y)
	   (/fl (fixnum->flonum x) y))
	  (else
	   (error "/" "not a number" y))))
      ((flonum? x)
       (cond
	  ((flonum? y)
	   (/fl x y))
	  ((fixnum? y)
	   (/fl x (fixnum->flonum y)))
	  (else
	   (error "/" "not a number" y))))
      (else
       (error "/" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    / ...                                                            */
;*---------------------------------------------------------------------*/
(define (/ x . y)
    (if (pair? y)
	(let loop ((result (2/ x (car y)))
		   (z (cdr y)))
	     (if (pair? z)
		 (loop (2/ result (car z))
		       (cdr z))
		 result))
	(2/ 1 x)))

;*---------------------------------------------------------------------*/
;*    abs ...                                                          */
;*---------------------------------------------------------------------*/
(define (abs x)
   (cond
      ((fixnum? x)
       (absfx x))
      ((flonum? x)
       (absfl x))
      (else
       (error "abs" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    floor ...                                                        */
;*---------------------------------------------------------------------*/
(define (floor x)
   (cond
      ((fixnum? x)
       x)
      ((flonum? x)
       (floorfl x))
      (else
       (error "floor" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    ceiling ...                                                      */
;*---------------------------------------------------------------------*/
(define (ceiling x)
   (cond
      ((fixnum? x)
       x)
      ((flonum? x)
       (ceilingfl x))
      (else
       (error "ceiling" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    truncate ...                                                     */
;*---------------------------------------------------------------------*/
(define (truncate x)
   (cond
      ((fixnum? x)
       x)
      ((flonum? x)
       (truncatefl x))
      (else
       (error "truncate" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    round ...                                                        */
;*---------------------------------------------------------------------*/
(define (round x)
   (cond
      ((fixnum? x)
       x)
      ((flonum? x)
       (roundfl x))
      (else
       (error "round" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    exp ...                                                          */
;*---------------------------------------------------------------------*/
(define (exp x)
   (cond
      ((fixnum? x)
       (expfl (fixnum->flonum x)))
      ((flonum? x)
       (expfl x))
      (else
       (error "exp" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    log ...                                                          */
;*---------------------------------------------------------------------*/
(define (log x)
   (cond
      ((fixnum? x)
       (logfl (fixnum->flonum x)))
      ((flonum? x)
       (logfl x))
      (else
       (error "log" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    sin ...                                                          */
;*---------------------------------------------------------------------*/
(define (sin x)
   (cond
      ((fixnum? x)
       (sinfl (fixnum->flonum x)))
      ((flonum? x)
       (sinfl x))
      (else
       (error "sin" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    cos ...                                                          */
;*---------------------------------------------------------------------*/
(define (cos x)
   (cond
      ((fixnum? x)
       (cosfl (fixnum->flonum x)))
      ((flonum? x)
       (cosfl x))
      (else
       (error "cos" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    tan ...                                                          */
;*---------------------------------------------------------------------*/
(define (tan x)
   (cond
      ((fixnum? x)
       (tanfl (fixnum->flonum x)))
      ((flonum? x)
       (tanfl x))
      (else
       (error "tan" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    asin ...                                                         */
;*---------------------------------------------------------------------*/
(define (asin x)
   (cond
      ((fixnum? x)
       (asinfl (fixnum->flonum x)))
      ((flonum? x)
       (asinfl x))
      (else
       (error "asin" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    acos ...                                                         */
;*---------------------------------------------------------------------*/
(define (acos x)
   (cond
      ((fixnum? x)
       (acosfl (fixnum->flonum x)))
      ((flonum? x)
       (acosfl x))
      (else
       (error "acos" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    atan ...                                                         */
;*---------------------------------------------------------------------*/
(define (atan x . y)
   (let ((y (if (pair? y)
		(let ((y (car y)))
		   (cond
		      ((fixnum? y)
		       (fixnum->flonum y))
		      ((flonum? y)
		       y)
		      (else
		       (error "atan" "not a number" y))))
		#f)))
      (define (do-atanfl x) 
	 (if (number? y)
	     (atanfl x y)
	     (atanfl x)))
      (cond
	 ((fixnum? x)
	  (do-atanfl (fixnum->flonum x)))
	 ((flonum? x)
	  (do-atanfl x))
	 (else
	  (error "atan" "not a number" x)))))

;*---------------------------------------------------------------------*/
;*    sqrt ...                                                         */
;*---------------------------------------------------------------------*/
(define (sqrt x)
   (cond
      ((fixnum? x)
       (sqrtfl (fixnum->flonum x)))
      ((flonum? x)
       (sqrtfl x))
      (else
       (error "sqrt" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    expt ...                                                         */
;*---------------------------------------------------------------------*/
(define (expt x y)
   (if (and (flonum? x) (flonum? y) (=fl x 0.0) (=fl y 0.0))
       1.0
       (cond
	  ((and (fixnum? x)
		(fixnum? y))
	   (flonum->fixnum (exptfl (fixnum->flonum x)  (fixnum->flonum y))))
	  ((fixnum? x)
	   (cond
	      ((flonum? y)
	       (exptfl (fixnum->flonum x) y))
	      (else
	       (error "expt" "not a number" y))))
	  ((flonum? x)
	   (cond
	      ((flonum? y)
	       (exptfl x y))
	      ((fixnum? y)
	       (exptfl x (fixnum->flonum y)))
	      (else
	       (error "expt" "not a number" y))))
	  (else
	   (error "expt" "not a number" x)))))

;*---------------------------------------------------------------------*/
;*    exact->inexact ...                                               */
;*---------------------------------------------------------------------*/
(define-inline (exact->inexact z)
   (if (exact? z)
       (fixnum->flonum z)
       z))

;*---------------------------------------------------------------------*/
;*    inexact->exact ...                                               */
;*---------------------------------------------------------------------*/
(define-inline (inexact->exact z)
   (if (inexact? z)
       (flonum->fixnum z)
       z))
 
;*---------------------------------------------------------------------*/
;*    number->string ...                                               */
;*---------------------------------------------------------------------*/
(define (number->string x . radix)
   (if (null? radix)
       (set! radix 10)
       (set! radix (car radix)))
   (cond
      ((fixnum? x)
       (integer->string x radix))
      ((flonum? x)
       (real->string x))
      (else
       (error "number->string" "Argument not a number" x))))

;*---------------------------------------------------------------------*/
;*    @deffn string->number@ ...                                       */
;*---------------------------------------------------------------------*/
(define (string->number x . radix)
   (define (integer-string? x r)
      (let loop ((i (-fx (string-length x) 1)))
	 (cond ((=fx -1 i)
		#t)
	       ((and (char>=? (string-ref x i) #\0)
		     (char<=? (string-ref x i) #\1)
		     (>=fx r 2))
		(loop (-fx i 1)))
	       ((and (char>=? (string-ref x i) #\2)
		     (char<=? (string-ref x i) #\7)
		     (>=fx r 8))
		(loop (-fx i 1)))
	       ((and (char>=? (string-ref x i) #\8)
		     (char<=? (string-ref x i) #\9)
		     (>=fx r 10))
		(loop (-fx i 1)))
	       ((and (char>=? (string-ref x i) #\a)
		     (char<=? (string-ref x i) #\f)
		     (=fx r 16))
		(loop (-fx i 1)))
	       ((and (char>=? (string-ref x i) #\A)
		     (char<=? (string-ref x i) #\F)
		     (=fx r 16))
		(loop (-fx i 1)))
	       ((or (char=? (string-ref x i) #\-)
		    (char=? (string-ref x i) #\+))
		(=fx i 0))
	       (else #f))))
   (define (real-string? x)
      (let ((len (string-length x)))
	 (let loop ((i 0)
		    (e #f)
		    (p 0))
	    (cond ((=fx i len)
		   #t)
		  ((and (char>=? (string-ref x i) #\0)
			(char<=? (string-ref x i) #\9))
		   (loop (+fx i 1)
			 e
			 0))
		  ((char=? (string-ref x i) #\.)
		   (loop (+fx i 1)
			 e
			 0))
		  ((or (char=? (string-ref x i) #\e)
		       (char=? (string-ref x i) #\E))
		   (if e
		       #f
		       (loop (+fx i 1)
			     #t
			     (+fx i 1))))
		  ((or (char=? (string-ref x i) #\-)
		       (char=? (string-ref x i) #\+))
		   (and (or (=fx i 0) (=fx i p))
			(loop (+fx i 1)
			      e
			      0)))
		  (else #f)))))
   (let ((rx (match-case radix
		(() 10)
		((?val)
		 (case val
		    ((2 8 10 16) val)
		    (else (error "string->number"
				 "Illegal radix"
				 val))))
		(else (error "string->number"
			     "Illegal number of optional arguments"
			     radix)))))
      (cond
	 ((integer-string? x rx)
	  (string->integer x rx))
	 ((real-string? x)
	  (if (=fx rx 10)
	      (string->real x)
	      (error "string->number"
		     "Only radix `10' is legal for floating point number"
		     rx)))
	 (else
	  #f))))
