/*---------------------------------------------------------------------*/
/*    serrano/prgm/project/bigloo/runtime/Clib/csystem.c               */
/*                                                                     */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Wed Jan 20 08:45:23 1993                          */
/*    Last change :  Sat Dec 30 11:30:13 2000 (serrano)                */
/*                                                                     */
/*    Le fichier ou on s'occupe de faire les choses `system'           */
/*---------------------------------------------------------------------*/
#include <bigloo.h>
#include <time.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/stat.h>

/*---------------------------------------------------------------------*/
/*    La table des handlers de signaux                                 */
/*---------------------------------------------------------------------*/
static obj_t handler[ 32 ];

/*---------------------------------------------------------------------*/
/*    get_handler ...                                                  */
/*---------------------------------------------------------------------*/
static obj_t
get_handler( num )
int num;
{
   return ((obj_t (*)())PROCEDURE_ENTRY(handler[ num ]))( handler[ num ],
                                                          BINT( num ),
                                                          BEOA );
}
    
/*---------------------------------------------------------------------*/
/*    obj_t ...                                                        */
/*---------------------------------------------------------------------*/
obj_t
c_signal( sig, thunk )
int   sig;
obj_t thunk;
{
   /* on met le thunk dans la table des handlers */
   handler[ sig ] = thunk;

   /* on le signal ... */
   signal( (int)sig, (void (*)())get_handler );

   return BUNSPEC;
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    get_signal_handler ...                                           */
/*---------------------------------------------------------------------*/
obj_t
get_signal_handler( sig )
int sig;
{
   return PROCEDUREP( handler[ sig ] ) ? handler[ sig ] : BFALSE;
}

/*---------------------------------------------------------------------*/
/*    c_date ...                                                       */
/*---------------------------------------------------------------------*/
char *
c_date()
{
#if( defined( sony_news ) )
   long now;
#else      
   time_t now;
#endif

   now = time( 0L );
   return ctime( &now );
}
      
/*---------------------------------------------------------------------*/
/*    long                                                             */
/*    bgl_last_modification_time ...                                   */
/*---------------------------------------------------------------------*/
long
bgl_last_modification_time( char *file )
{
   struct stat stat;

   if( lstat( file, &stat ) )
      return -1;
   else
      return ((((unsigned long)(stat.st_mtime)) << 3) >> 3);
}

/*---------------------------------------------------------------------*/
/*    long                                                             */
/*    bgl_file_size ...                                                */
/*---------------------------------------------------------------------*/
long
bgl_file_size( char *file )
{
   struct stat stat;

   if( lstat( file, &stat ) )
      return -1;
   else
      return stat.st_size;
}

/*---------------------------------------------------------------------*/
/*    int                                                              */
/*    bgl_chmod ...                                                    */
/*---------------------------------------------------------------------*/
int
bgl_chmod( char *file, int read, int write, int exec ) {
   return chmod( file,
		 (read ? S_IRUSR : 0) |
		 (write ? S_IWUSR : 0) |
		 (exec ? S_IXUSR : 0) );
}
		 
		 
