;*=====================================================================*/
;*    serrano/prgm/project/bigloo/recette/main.scm                     */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Nov  2 17:24:13 1992                          */
;*    Last change :  Wed Nov 21 13:31:21 2001 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The recette entry point                                          */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module main
   
   (main   recette)
   
   (import vital
	   bps
	   hash
	   bool
	   list
	   vector
	   struct
	   print
	   bchar
	   string
	   kwote
	   case
	   bind-exit
	   vararity
	   apply
	   globalisation
	   glo_cell
	   kapture
	   filtre
	   match
	   rgc-trap
	   rgc-jm
	   rgc-eval
	   rgc
	   input-port
	   read
	   callcc
	   fringe
	   tail
	   extern
	   big-file
	   sqic
	   reval
	   inline
	   letrec
	   macro
	   flonum
	   number
	   define
	   cse
	   error
	   include
	   0cfa
	   sua
	   alias
	   alias-aux
	   module
	   import1
	   import2
	   object
	   object4
	   hygien
	   wind
	   dsssl
	   peek
	   unicode
	   optim
	   pregexp)
   
   (export (do-test name thunk good?)
	   (test-module name file)
	   *recette-port*)
   
   (option (set! *debug* #f)))
   
;*---------------------------------------------------------------------*/
;*    Des variables statiques                                          */
;*---------------------------------------------------------------------*/
(define *test-number*   0)
(define *nb-test*       0)
(define *nb-err*        0)
(define *module-name*   "")
(define *verbose*       #f)
(define *silent*        #t)
(define *recette-port*  #f)
(define *tick-number*   -1)
(define *callcc?*       #t)
(define *dumping*       #f)

;*---------------------------------------------------------------------*/
;*    tick ...                                                         */
;*---------------------------------------------------------------------*/
(define (tick)
   (set! *tick-number* (+fx 1 *tick-number*))
   (if (=fx *tick-number* 4)
       (set! *tick-number* 0))
   (write-char (integer->char 8))
   (case *tick-number*
      ((0) (write-char #\|))
      ((1) (write-char #\/))
      ((2) (write-char #\-))
      ((3) (write-char #\\))))

;*---------------------------------------------------------------------*/
;*    recette-port ...                                                 */
;*---------------------------------------------------------------------*/
(define recette-port
   (let ((port (open-output-file "recette.log")))
      (if (not (output-port? port))
	  (error "recette-port" "Can't open output-file" "recette.log")
	  (lambda ()
	     port))))

;*---------------------------------------------------------------------*/
;*    do-test ...                                                      */
;*---------------------------------------------------------------------*/
(define (do-test name thunk wanted)
   (set! *test-number* (+ 1 *test-number*))
   (set! *nb-test* (+ 1 *nb-test*))
   (define (correct? result wanted)
      (or (equal? result wanted)
	  (and (flonum? result)
	       (flonum? wanted)
	       (<fl (absfl (-fl result wanted)) 0.00001))))
   (try (let ((result (thunk)))
	   (if (correct? result wanted)
	       (begin
		  (if (not *silent*)
		      (begin
			 (display* *test-number* #\. *module-name* " : "
				   name " --> ")
			 (display "ok.")))
		  (if *verbose*
		      (begin
			 (display " [")
			 (write-circle result)
			 (print "]"))
		      (if (not *silent*)
			  (newline))))
	       (begin
		  (set! *nb-err* (+ 1 *nb-err*))
		  (display* *test-number* #\. *module-name* " : " name )
		  (let ((p (open-output-string))
			(w (open-output-string)))
		     (display "provided [" p)
		     (write result p)
		     (display "]" p)
		     (display "wanted [" w)
		     (write wanted w)
		     (display "]" w)
		     (error name
			    (close-output-port p)
			    (close-output-port w))))))
	(lambda (escape proc obj msg)
	   (flush-output-port (current-output-port))
	   (notify-error proc obj msg)
	   (flush-output-port (current-error-port))
	   (escape #f))))

;*---------------------------------------------------------------------*/
;*    test-module ...                                                  */
;*---------------------------------------------------------------------*/
(define (test-module module-name file-name)
   (set! *module-name* module-name)
   (set! *test-number* 0)
   (if (not *silent*)
       (newline))
   (print file-name ":"))

;*---------------------------------------------------------------------*/
;*    recette ...                                                      */
;*---------------------------------------------------------------------*/
(define (recette argv)
   (args-parse (cdr argv)
      (section "Misc")
      (("-help" (help "This help message"))
       (args-parse-usage #f)
       (exit 0))
      (section "Verbosity")
      (("-v" (help "Be verbose"))
       (set! *silent* #f)
       (set! *verbose* #f))
      (("-V" (help "Be verbose and show values"))
       (set! *silent* #f)
       (set! *verbose* #t))
      (("--verbose" ?level (help "Verbosisty (1 = -v, 2 = -V, else = error)"))
       (cond
	  ((string=? level "1")
	   (set! *silent* #f)
	   (set! *verbose* #f))
	  ((string=? level "2")
	   (set! *silent* #f)
	   (set! *verbose* #t))
	  (else
	   (args-parse-error the-remaining-args))))
      (("-args-parse" ?dum1 ?dum2 (help "Use this option to check ags-parse"))
       (print "dummy1=" dum1 " dummy2=" dum2))
      (("--args-parse" ?dum1 ?dum2 (help "--args-parse dummy1 dummy2"
					 "Use this option to check ags-parse"))
       (print "dummy1=" dum1 " dummy2=" dum2))
      (("-a?dummy" (help "Use this option to check ags-parse"))
       (print "dummy=" dummy))
      (("-A?dummy" (help "-a<dummy>" "Use this option to check ags-parse"))
       (print "dummy=" dummy))
      (("--no-call/cc" (help "Don't check for call/cc"))
       (set! *callcc?* #f))
      (("--dump" ?fname (help "Don't test but dump a binary structure"))
       (set! *dumping* fname))
      (else
       (args-parse-error else)))
   (if (string? *dumping*)
       (begin
	  (dump-obj *dumping*)
	  (print #\Newline "------------------------------")
	  (print (cond-expand
		    (bigloo-c "C dump done...")
		    (bigloo-jvm "JVM dump done..."))))
       (begin
	  (set! *recette-port* (open-output-file "recette.log"))
	  (if (not (output-port? *recette-port*))
	      (error "recette-port" "Can't open output-file" "recette.log"))
	  (try (begin
		  (test-vital)
		  (test-bps)
		  (test-cell)
		  (test-modulel)
		  (test-hash)
		  (test-bool)
		  (test-number)
		  (test-flonum)
		  (test-list)
		  (test-vector)
		  (test-struct)
		  (test-print)
		  (test-char)
		  (test-string)
		  (test-kwote)
		  (test-case)
		  (test-bind-exit)
		  (test-vararity)
		  (test-apply)
		  (test-globalisation)
		  (test-kapture)
		  (test-filtre)
		  (test-match)
		  (test-rgc)
		  (test-rgc-trap)
		  (test-rgc-jm)
		  (test-rgc-eval)
		  (test-input-port)
		  (test-read)
		  (if *callcc?*
		      (begin
			 (test-callcc)
			 (test-fringe)
			 (test-wind)))
		  (test-dsssl)
		  (test-tail)
		  (test-extern)
		  (test-sqic)
		  (test-eval)
		  (test-inline)
		  (test-letrec)
		  (test-macro)
		  (test-define)
		  (test-cse)
		  (test-error)
		  (test-include)
		  (test-0cfa)
		  (test-sua)
		  (test-alias)
		  (test-object)
		  (test-object4)
		  (test-hygien)
		  (test-peek)
		  (test-unicode)
		  (test-optim)
		  (test-pregexp)
		  )
	       (lambda (escape proc mes obj)
		  (notify-error proc mes obj)
		  (set! *nb-err* (+ 1 *nb-err*))
		  (exit -1)))
	  (close-output-port *recette-port*)
	  (print #\Newline "------------------------------")
	  (if (> *nb-err* 0)
	      (begin
		 (notify-error "recette" *nb-err* "error(s) occur")
		 -1)
	      (begin
		 (print "recette done, the " *nb-test* " tests are clear")
		 0)))))
 
 
