(module jvm_constr
   (import type_type ast_var ast_node
	   object_class     ; tclass
           jvm_extern jvm_env jvm_instr )
   (export (jvm-constructors env::env me::symbol super::symbol)) )

;;
;; Construct all the JVM <*init> methods (known as constructors)
;;
(define (jvm-constructors env::env me::symbol super::symbol)
   (list (constr env me super '())
	 (constr env me super '(int int))
	 (constr env me super '(int int int))
	 (clinit env me) ))

;;
;; All <init>s
;;
(define (constr env me super args)
   (define (name s l)
      (string->symbol (string-append s (integer->string (length l)))) )
   (let ( (init (name "init" args)) (sinit (name "sinit" args)) )
      (env-declare env init `(method ,me (public) void "<init>" ,@args))
      (env-declare env sinit `(method ,super (public) void "<init>" ,@args))
      (let ( (params (map (lambda (t) (gensym "A")) args)) )
	 `(method ,init (this ,@params) ()
		  (aload this)
		  ,@(map (lambda (p) `(iload ,p)) params)
		  (invokespecial ,sinit)
		  (return) ))))

;;
;; the <clinit> method
;;
(define (clinit env me)
   (env-declare env 'clinit `(method ,me (public static) void "<clinit>"))
   ;; CARE !! Oh et puis c'est pas mon probleme...
;   (if *longislong*
;       (env-declare env 'minit `(method ,me (public static) jobject
;					"module-initialization"
;					long (vector byte) ))
;       (env-declare env 'minit `(method ,me (public static) jobject
;					"module-initialization"
;					int (vector byte) )) )
   `(method clinit () ()
	    ; (ldc ,(symbol->string *module*))
	    ; (invokestatic ,(jlib-declare env 'print))
	    ,@(reverse! (env-clinit-code env))
;	    ;; CARE intext doesn't load hash (for example :-)
;	    ,(if *longislong* '(lconst_0) '(iconst_0))
;	    (iconst_0)
;	    (newarray byte)
;	    (invokestatic minit)
;	    (pop)
	    (return) ))
   
   
