;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Cc/cc.scm                   */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Apr 29 09:51:32 1995                          */
;*    Last change :  Tue Nov 13 07:24:57 2001 (serrano)                */
;*    Copyright   :  1995-2001 Manuel Serrano, see LICENSE file        */
;*    -------------------------------------------------------------    */
;*    The C compilation                                                */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cc_cc
   (export  (cc name ::bool))
   (import  tools_speek
	    tools_error
	    cc_exec
	    engine_param))

;*---------------------------------------------------------------------*/
;*    cc ...                                                           */
;*---------------------------------------------------------------------*/
(define (cc name need-to-return)
   (cond
      ((string=? (os-class) "unix")
       (unix-cc name need-to-return))
      (else
       (user-error "cc" "Unknow os" (os-class)))))

;*---------------------------------------------------------------------*/
;*    unix-cc ...                                                      */
;*---------------------------------------------------------------------*/
(define (unix-cc name need-to-return)
   (verbose 1 "   . cc (" *cc* ")" #\Newline)
   (cond
      ((not (string? name))
       (error "cc" "can't process cc on stdout" name))
      (else
       (let ((cc (string-append *cc*
				" "
				*cc-options*
				" -c "
				" -I. "
				(let loop ((path *lib-dir*))
				   (if (null? path)
				       ""
				       (string-append "-I"
						      (car path)
						      " "
						      (loop (cdr path)))))
				(if (or *c-debug* (>fx *bdb-debug* 0))
				    (string-append " " *c-debug-option*)
				    "")
				(if (>fx *heap-debug* 0)
				    (string-append " " *heap-debug-copt*)
				    "")
				" " name ".c ")))
	  (verbose 2 "      ["  cc #\] #\Newline)
	  (let* ((basename (basename name))
		 (rm-csrc  (if *rm-c-files*
			       (string-append "&& /bin/rm -f " name ".c ")
			       ""))
		 (pwd      (let ((vpwd (getenv "PWD")))
			      (if (string? vpwd)
				  vpwd
				  (pwd))))
		 (mv-obj   (if (and (not (string=? basename name))
				    (not (string=? pwd (dirname name)))
				    (not (string=? "." (dirname name))))
			       (string-append "&& /bin/mv "
					      basename 
					      ".o "
					      name
					      ".o 2>&1 >/dev/null ")
			       ""))
		 (cmd      (string-append cc mv-obj rm-csrc)))
	     (exec cmd need-to-return "cc"))))))
