;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bmacs/ude/ude-root.el                */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Nov  8 07:27:43 1998                          */
;*    Last change :  Sat Dec  2 11:46:20 2000 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The `Unix Development Environment' root settings.                */
;*    -------------------------------------------------------------    */
;*    The root directory is the closest directory that contains a      */
;*    Makefile that contains the name of the file.                     */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(provide 'ude-root)
(require 'ude-autoload)
(require 'ude-config)
(require 'ude-custom)

;*---------------------------------------------------------------------*/
;*    ude-auto-find-root-directory ...                                 */
;*    -------------------------------------------------------------    */
;*    This function search the root directory for the file named       */
;*    FNAME. It returns NIL if no root directory is found.             */
;*    -------------------------------------------------------------    */
;*    To seek the root directory, we search for a Makefile that        */
;*    contains the prefix of FNAME.                                    */
;*    -------------------------------------------------------------    */
;*    The directory returned by this function _contains_ an ending     */
;*    / character.                                                     */
;*---------------------------------------------------------------------*/
(defun ude-auto-find-root-directory (fname)
  "Automatically find a root directory for file FNAME."
  (if (not (stringp fname))
      nil
    (let* ((fname  (expand-file-name fname))
	   (dir    (file-name-directory fname))
	   (file   (file-name-nondirectory fname))
	   (prefix (ude-string-prefix file))
	   (depth  ude-root-search-depth)
	   (res    nil))
      (while (and (> depth 0)
		  (> (length dir) 0)
		  (not (string= dir "//"))
		  (not res))
	(let ((makefile (concat dir ude-makefile)))
	  (if (file-exists-p makefile)
	      (let* ((cmd  (concat ude-grep-w " '" prefix "[.]?' " makefile))
		     (grep (exec-to-string cmd)))
		(if (string-match prefix grep)
		    (setq res dir)
		  (let ((dirname (substring dir 0 (- (length dir)))))
		    (setq depth (+ 1 depth))
		    (setq dir (file-name-directory dirname)))))
	    (let ((dirname (substring dir 0 (- (length dir) 1))))
	      (setq depth (+ 1 depth))
	      (setq dir (file-name-directory dirname))))))
      res)))

;*---------------------------------------------------------------------*/
;*    ude-auto-set-root-directory ...                                  */
;*    -------------------------------------------------------------    */
;*    This sets the ude-root-directory each time Ude mode is entered.  */
;*---------------------------------------------------------------------*/
(defun ude-auto-set-root-directory ()
  (let ((d (ude-auto-find-root-directory (buffer-file-name (current-buffer)))))
    (if (stringp d)
	(setq ude-root-directory d)
      (setq ude-root-directory (ude-root-trailing-slash default-directory))))
  (ude-set-root-modeline))

;*---------------------------------------------------------------------*/
;*    ude-user-set-root-directory ...                                  */
;*    -------------------------------------------------------------    */
;*    This sets the ude-root-directory with the user choice.           */
;*---------------------------------------------------------------------*/
(defun ude-user-set-root-directory (dir)
  (interactive "DRoot directory: ")
  (if (and (stringp dir) (file-exists-p dir))
      (progn
	(setq ude-root-directory
	      (ude-root-trailing-slash (expand-file-name dir)))
	(ude-set-root-modeline))
    (ude-error "Can't find root directory %S" dir)))

;*---------------------------------------------------------------------*/
;*    ude-root-trailing-slash ...                                      */
;*    -------------------------------------------------------------    */
;*    Add a / at the end of the root path if that character is         */
;*    not present yet.                                                 */
;*---------------------------------------------------------------------*/
(defun ude-root-trailing-slash (dir)
  (if (not (eq (aref dir (- (length dir) 1)) ?/))
      (concat dir "/")
    dir))

;*---------------------------------------------------------------------*/
;*    ude-modeline-id ...                                              */
;*---------------------------------------------------------------------*/
(defvar ude-modeline-id nil)
(make-variable-buffer-local 'ude-modeline-id)
  
;*---------------------------------------------------------------------*/
;*    ude-set-root-modeline ...                                        */
;*    -------------------------------------------------------------    */
;*    This function sets the modeline according to the root directory. */
;*---------------------------------------------------------------------*/
(defun ude-set-root-modeline ()
  (let* ((id (if (stringp ude-root-directory)
		 (let* ((text (file-name-nondirectory
			       (substring
				ude-root-directory
				0
				(- (length ude-root-directory) 1))))
			(glyph (make-glyph text)))
		   (set-glyph-face glyph 'ude-modeline-root-face)
		   glyph)
	       (let ((glyph (make-glyph "no root")))
		 (set-glyph-face glyph 'ude-modeline-no-root-face)
		 glyph))))
    (if (consp ude-modeline-id)
	(rplacd ude-modeline-id id)
      (progn
	(setq ude-modeline-id
	      (cons (copy-extent modeline-buffer-id-left-extent) id))
	(setq mode-line-buffer-identification
	      (cons ude-modeline-id
		    (mapcar '(lambda (prop)
			       (let ((name (cdr prop)))
				 (if (string= "XEmacs%N:" name)
				     (cons (car prop) "%N:")
				   prop)))
			    mode-line-buffer-identification)))))))

