;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bmacs/ude/ude-info.el                */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jul 31 09:29:56 1998                          */
;*    Last change :  Fri Jan  8 18:29:36 1999 (serrano)                */
;*    -------------------------------------------------------------    */
;*    This module implements an Xemacs configuration for the Info      */
;*    mode. To initialize ude-info, just call UDE-INFO-INIT.           */
;*                                                                     */
;*    This mode check the shell variable UDE-INFOPATH for extra        */
;*    directories containing info files. These directory must          */
;*    contain dir files.                                               */
;*=====================================================================*/
 
;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(provide 'ude-info)
(require 'info)
(require 'ude-icon)
(require 'ude-toolbar)

;*---------------------------------------------------------------------*/
;*    ude-info-initialized-p ...                                       */
;*    -------------------------------------------------------------    */
;*    Is ude-info initialized for that buffer?                         */
;*---------------------------------------------------------------------*/
(defvar ude-info-initialized-p nil)
(make-variable-buffer-local 'ude-info-initialized-p)

;*---------------------------------------------------------------------*/
;*    ude-info-font-lock-keywords ...                                  */
;*---------------------------------------------------------------------*/
(defvar ude-info-font-lock-keywords nil)

;*---------------------------------------------------------------------*/
;*    ude-info-init ...                                                */
;*---------------------------------------------------------------------*/
(defun ude-info-init (flock)
  (setq ude-info-font-lock-keywords flock)
  (if (not ude-info-initialized-p)
      (progn
	(setq ude-info-initialized-p t)
	(add-hook 'Info-mode-hook (function ude-info-mode-hook)))))

;*---------------------------------------------------------------------*/
;*    Various info toolbar button                                      */
;*---------------------------------------------------------------------*/
(defvar ude-info-back-button
  (toolbar-make-button-list ude-back-icon))
(defvar ude-info-forward-button
  (toolbar-make-button-list ude-forward-icon))
(defvar ude-info-up-button
  (toolbar-make-button-list ude-up-icon))
(defvar ude-info-next-button
  (toolbar-make-button-list ude-next-icon))
(defvar ude-info-home-button
  (toolbar-make-button-list ude-home-icon))
(defvar ude-info-hotlist-button
  (toolbar-make-button-list ude-hotlist-icon))
(defvar ude-info-open-button
  (toolbar-make-button-list ude-open-icon))
(defvar ude-info-print-button
  (toolbar-make-button-list ude-print-icon))
(defvar ude-info-search-button
  (toolbar-make-button-list ude-search-icon))
(defvar ude-info-help-button
  (toolbar-make-button-list ude-help-icon))
(defvar ude-info-info-button
  (toolbar-make-button-list ude-info-icon))
(defvar ude-info-quit-button
  (toolbar-make-button-list ude-quit-icon))

;*---------------------------------------------------------------------*/
;*    ude-info opened toolbar ...                                      */
;*---------------------------------------------------------------------*/
(defvar ude-info-opened-toolbar
  '(;;close button
    [ude-close-toolbar-button ude-close-info-toolbar t "Info toolbar"]
    [:style 2d :size 2]
    ;; the quit button
    [ude-info-quit-button delete-frame t "Close Info Frame"]
    [:style 2d :size 2]
    ;; back action
    [ude-info-back-button ude-info-back t
    "Return to the previous page in History list"]
    ;; forward action
    [ude-info-forward-button ude-info-forward t
    "Go to the next page in History list"]
    ;; the up action
    [ude-info-up-button ude-info-up t
    "Go to the superior node"]
    ;; the next action
    [ude-info-next-button ude-info-next t
    "Go to the next node"]
    [:style 2d :size 2]
    ;; home action
    [ude-info-home-button ude-info-home t
    "Go to the home page"]
    ;; hotlist action
    [ude-info-hotlist-button ude-info-hotlist t
    "Select an ude-info page"]
    ;; the open action
    [ude-info-open-button ude-info-open t
    "Open an ude-info page"]
    [:style 2d :size 2]
    ;; the print action
    [ude-info-print-button ude-info-print t
    "Print this ude-info page"]
    ;; the search action
    [ude-info-search-button ude-info-search t
    "Search for a string"]
    [:style 2d :size 2]
    ;; flushing right
    nil
    [:style 2d :size 2]
    ;; the help action
    [ude-info-help-button ude-info-help t
    "The help for ude-info"]
    ;; the info button
    [ude-info-info-button ude-info-info t
    "The online documentation for Info"]))

(fset 'ude-info-back 'Info-last)

(defun ude-info-forward ()
  (Info-last -1))

(fset 'ude-info-up 'Info-up)
(fset 'ude-info-next 'Info-next)

(defun ude-info-home ()
  (let ((up (Info-extract-pointer "up" t)))
    (while (and (stringp up) (not (string-equal up "(dir)")))
      (progn
	(Info-up)
	(setq up (Info-extract-pointer "up" t))))))

(defun ude-info-hotlist ()
  (interactive)
  (Info-goto-node "(dir)"))

(fset 'ude-info-print 'print-buffer)
(fset 'ude-info-open 'Info-visit-file)
(fset 'ude-info-search 'Info-search)
(fset 'ude-info-help 'describe-mode)

(defun ude-info-info ()
  (interactive)
  (Info-find-node "info" "Top"))

;*---------------------------------------------------------------------*/
;*    ude-info-closed-toolbar ...                                      */
;*---------------------------------------------------------------------*/
(defvar ude-info-closed-toolbar
  '([ude-open-toolbar-button ude-open-info-toolbar t "Open toolbar"]))

;*---------------------------------------------------------------------*/
;*    Opening/closing toolbars ... ...                                 */
;*---------------------------------------------------------------------*/
(defun ude-close-info-toolbar ()
  (ude-open-close-toolbar ude-info-closed-toolbar))

(defun ude-open-info-toolbar ()
  (ude-open-close-toolbar ude-info-opened-toolbar))

;*---------------------------------------------------------------------*/
;*    ude-info-follow-clicked-node ...                                 */
;*---------------------------------------------------------------------*/
(defun ude-info-follow-clicked-node (event)
  "Follow a node reference near clicked point.  Like M, F, N, P or U command.
At end of the node's text, moves to the next node."
  (interactive "@e")
  (or (and (event-point event)
	   (ude-info-follow-nearest-node
	    (max (progn
		   (select-window (event-window event))
		   (event-point event))
		 (1+ (point-min)))))
      (error "click on a cross-reference to follow")))

;*---------------------------------------------------------------------*/
;*    ude-info-follow-nearest-node ...                                 */
;*---------------------------------------------------------------------*/
(defun ude-info-follow-nearest-node (point)
  "Follow a node reference near point.  Like M, F, N, P or U command.
At end of the node's text, moves to the next node."
  (interactive "d")
  (let ((data (Info-find-nearest-node point)))
    (if (null data)
	nil
      (let ((msg (format (car data) (nth 1 (nth 1 data)))))
	(message "%s" msg)
	(switch-to-buffer-other-frame "toto")
	(eval (nth 1 data))
	(message "%sdone" msg))
      t)))

;*---------------------------------------------------------------------*/
;*    ude-info-mode-hook ...                                           */
;*---------------------------------------------------------------------*/
(defun ude-info-mode-hook ()
  ;; additional files
  (let ((path (getenv "INFOPATH")))
    (if path
	(setq Info-directory-list
	      (append (split-string path path-separator)
		      Info-directory-list))))
  ;; ude-info faces
  (custom-set-faces
   '(info-xref ((t (:bold t :underline t :foreground "#0000ee"))))
   '(info-node ((t (:bold t :underline t :foreground "goldenrod")))))
  ;; the toolbar
  (set-specifier default-toolbar-visible-p t)
  (set-specifier default-toolbar ude-info-opened-toolbar (current-buffer))
  ;; the fontification
  (add-hook 'Info-select-hook
	    '(lambda ()
	       (if ude-info-fontify
		   (font-lock-fontify-buffer))))
  (add-hook 'Info-startup-hook
	    '(lambda ()
	       (let ((kwd ude-info-font-lock-keywords))
		 (if (consp kwd)
		     (setq Info-font-lock-keywords kwd)))))
  ;; the ude-info-hook
  (run-hooks 'ude-info-mode-hook))

