;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bmacs/ude/ude-error.el               */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Nov 11 08:19:19 1998                          */
;*    Last change :  Fri Aug 27 08:02:40 1999 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Ude error management                                             */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(provide 'ude-error)
(require 'ude-custom)

;*---------------------------------------------------------------------*/
;*    ude-error ...                                                    */
;*    -------------------------------------------------------------    */
;*    This function display the error message and, when customized,    */
;*    play the error sound.                                            */
;*---------------------------------------------------------------------*/
(defun ude-error (msg &rest rest)
  ;; play a sound
  (if ude-error-sound-p
      (if (device-sound-enabled-p)
	  (let ((synchronous-sounds nil))
	    (condition-case ()
		(play-sound 'ude-error)
	      (error (beep))))
	(beep)))
  (let ((msg (apply 'format (cons msg rest))))
    ;; display the error message
    (put-text-property 0 (length msg) 'face 'ude-error-face msg)
    (display-message 'no-log msg)
    (sit-for 2 nil))
  nil)
    
;*---------------------------------------------------------------------*/
;*    ude-set-error-sound-volume ...                                   */
;*    -------------------------------------------------------------    */
;*    This function adds a sound configuration to the sound-alist.     */
;*    There is no need to first remove the sound from the Xemacs alist */
;*    because if it already exists the old sound is removed by         */
;*    LOAD-SOUND-FILE.                                                 */
;*---------------------------------------------------------------------*/
(defun ude-set-error-sound-volume (symbol value)
  (if (device-sound-enabled-p)
      (progn
	(set-default symbol value)
	(condition-case ()
	    (load-sound-file ude-error-sound-file 'ude-error value)
	  (error '())))))
