;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bmacs/cee/cee-indent.el              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon May 25 07:27:11 1998                          */
;*    Last change :  Sat Nov 13 09:47:52 1999 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The Cee indent.                                                  */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(provide 'cee-indent)
(require 'ude-autoload)
(require 'cee-config)
(if (featurep 'c-mode)
    (require 'c-mode))

;*---------------------------------------------------------------------*/
;*    cee-indent-exp ...                                               */
;*---------------------------------------------------------------------*/
(defun cee-indent-exp ()
  (interactive)
  (condition-case err
      (c-indent-exp)
    (error
     (if (and (consp (cdr err)) (stringp (car (cdr err))))
	 (ude-error "Illegal expression")
       nil))))
      
;*---------------------------------------------------------------------*/
;*    cee-external-indent-process ...                                  */
;*---------------------------------------------------------------------*/
(defvar cee-external-indent-process '()
  "The external Cee indent process")

;*---------------------------------------------------------------------*/
;*    cee-external-indent-sentinel ...                                 */
;*---------------------------------------------------------------------*/
(defun cee-external-indent-sentinel (proc msg)
  (if (equal (substring msg 0 8) "finished")
      (progn
	(message "Indent done ...")
	(beginning-of-buffer))
    (progn
      (beep)
      (message "Abnormal end: %s" msg ))))

;*---------------------------------------------------------------------*/
;*    cee-external-indent ...                                          */
;*---------------------------------------------------------------------*/
(defun cee-external-indent ()
  "Call an external global indent on current buffer"
  (interactive)
  (cond
   ((buffer-modified-p)
    (ude-error "Can't Indent modified buffers ..."))
   (t
    (end-of-buffer)
    (kill-region 1 (point))
    (message "Indenting C file")
    (setq cee-external-indent-process
	  (start-process "indent"
			 (buffer-name)
			 cee-external-indent
			 cee-external-indent-opt
			 (buffer-file-name)))
    (set-process-sentinel cee-external-indent-process
			  'cee-external-indent-sentinel))))


;*---------------------------------------------------------------------*/
;*    cee-indent-hook ...                                              */
;*---------------------------------------------------------------------*/
(defun cee-indent-hook ()
  (if (boundp 'c-version)
      (progn
	(cond
	 ((not (boundp 'c-style-alist))
	  (error "cee-indent-init:cannot find c-style-alist"))
	 ((consp (assoc "k&r" c-style-alist))
	  (c-set-style "k&r"))
	 ((consp (assoc "K&R" c-style-alist))
	  (c-set-style "K&R"))
	 (t
	  (error "cee-indent-init:cannot find k&r style")))
	(setq c-echo-syntactic-information-p t)
	(setq c-basic-offset 3)
	(c-set-offset 'access-label '0)
	(c-set-offset 'case-label '+))
    (progn
      (make-local-variable 'tab-width)
      (setq tab-width 8)
      ;; tab indent la ligne courante
      (setq c-tab-always-indent t)
      ;; la taille des indentations
      ;; le auto-newline
      (setq c-auto-newline nil)
      (setq c-indent-level 3)
      ;; la taille des indentations des if
      (setq c-continued-statement-offset 0)
      (setq c-continued-brace-offset 0)
      ;; les accollades en debut de ligne
      (setq c-brace-offset 0)
      (setq c-argdecl-indent 0)
      ;; les label et les case
      (setq c-label-offset 0))))


