;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bmacs/bee/bee-toolbar.el             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jun  5 21:03:27 1998                          */
;*    Last change :  Tue May 16 11:27:37 2000 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The bee toolbar system.                                          */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(provide 'bee-toolbar)
(require 'bee-autoload)
(require 'ude-icon)
(require 'ude-toolbar)
(require 'ude-autoload)
(require 'dbg-autoload)

;*---------------------------------------------------------------------*/
;*    Various compile toolbar button                                   */
;*---------------------------------------------------------------------*/
(defvar bee-tag-button
  (toolbar-make-button-list ude-tag-icon))
(defvar bee-decl-button
  (toolbar-make-button-list ude-declaration-icon))
(defvar bee-ibuilder-button
  (toolbar-make-button-list ude-ibuilder-icon))
(defvar bee-indent-button
  (toolbar-make-button-list ude-indent-icon))
(defvar bee-import-button
  (toolbar-make-button-list ude-import-icon))
(defvar bee-export-button
  (toolbar-make-button-list ude-export-icon))
(defvar bee-c-import-button
  (toolbar-make-button-list ude-c-import-icon))
(defvar bee-compile-button
  (toolbar-make-button-list ude-compile-icon))
(defvar bee-root-button
  (toolbar-make-button-list ude-root-icon))
(defvar bee-make-make-button
  (toolbar-make-button-list ude-make-make-icon))
(defvar bee-make-entry-button
  (toolbar-make-button-list ude-make-entry-icon))
(defvar bee-repl-button
  (toolbar-make-button-list ude-repl-icon))
(defvar bee-bdb-button
  (toolbar-make-button-list ude-dbg-icon))
(defvar bee-connect-button
  (toolbar-make-button-list ude-dbg-connect-icon))
(defvar bee-profile-button
  (toolbar-make-button-list ude-profile-icon))
(defvar bee-info-button
  (toolbar-make-button-list ude-info-icon))
(defvar bee-browse-button
  (toolbar-make-button-list ude-browse-icon))
(defvar bee-begoo-button
  (toolbar-make-button-list ude-graph-icon))

;*---------------------------------------------------------------------*/
;*    bee opened toolbar ...                                           */
;*---------------------------------------------------------------------*/
(defvar bee-opened-toolbar
  (let* ((sep (if (bee-begoo-ready-p)
		  nil
		 (list [:style 2d :size 2])))
	 (clo (cons
	       ;; the close button
	       [ude-close-toolbar-button bee-close-toolbar t "Bee toolbar"]
	       sep))
	 (beg (list
	       ;; the begoo button
	       [bee-begoo-button bee-begoo-start t "Module graph"]))
	       
	 (cmn (append
	       (list
		;; either the usage button or the browser button
		;; either the find or the ibuilder button
		(if (bee-interface-builder-ready-p)
		    ;; the ibuilder button
		    [bee-ibuilder-button bee-interface-builder-start t "Interface builder"]
		    ;; the find button
		    [bee-tag-button bee-tags-find t "Find definition"])

		(if (bee-browser-ready-p)
		    ;; the ibuilder button
		    [bee-browse-button bee-browser-start t "Browser"]
		    ;; the doc buttom
		    [bee-decl-button bee-usage-find t "Definition documentation"]))
	       sep

	       (list
		;; the indent button
		[bee-indent-button bee-external-indent t "Indent whole buffer"])
	       sep

	       (list
		;; the import button
		[bee-import-button bee-import-binding t "Import definition"]
		;; the export button
		[bee-export-button bee-export-definition t "Export definition"]
		;; the C importation button
		[bee-c-import-button bee-import-c-file t "Import C definition"])
	       sep

	       (list
		;; the compile button
		[bee-compile-button ude-mode-compile-from-menu t "Compile"]
		;; the root button
		[bee-root-button ude-user-set-root-directory t "Set new Bee root directory"]
		;; the bmake button
		[bee-make-make-button bee-generate/update-makefile t "Generate/update Makefile"]
		;; the bmake entry button
		[bee-make-entry-button ude-add-user-makefile-entry t "Add Makefile entry"])
	       sep

	       (list
		;; the repl button
		[bee-repl-button ude-repl-other-frame t "Start a read-eval-print loop"]
		;; the profile button
		[bee-profile-button bee-profiler-start t "Profiling"]
		;; the bdb button
		[bee-bdb-button bee-kbdb-start t "Debugging"])
	       sep))
	 (inf  (list
		;; the info button
		[bee-info-button bee-docline t
		"The online documentation for Bee"])))
    (append clo
	    (if (bee-begoo-ready-p)
		beg
	      '())
	    cmn
	    (if (bee-begoo-ready-p)
		inf
	      (cons nil inf)))))

;*---------------------------------------------------------------------*/
;*    bee-closed-toolbar ...                                           */
;*---------------------------------------------------------------------*/
(defvar bee-closed-toolbar
  '([ude-open-toolbar-button bee-open-bee-toolbar t "Open toolbar"]))

;*---------------------------------------------------------------------*/
;*    Opening/closing the Bee toolbar ...                              */
;*---------------------------------------------------------------------*/
(defun bee-close-toolbar ()
  (ude-open-close-toolbar bee-closed-toolbar))

(defun bee-open-bee-toolbar ()
  (ude-open-close-toolbar bee-opened-toolbar))

;*---------------------------------------------------------------------*/
;*    bee-toolbar-init ...                                             */
;*---------------------------------------------------------------------*/
(defun bee-toolbar-init ()
  (set-specifier default-toolbar-visible-p t (current-buffer))
  (set-specifier default-toolbar bee-opened-toolbar (current-buffer)))


