// This file may be redistributed and modified only under the terms of
// the GNU Lesser General Public License (See COPYING for details).
// Copyright 2000-2001 Stefanus Du Toit and Alistair Riddoch.
// Automatically generated using gen_cc.py.

#ifndef ATLAS_OBJECTS_ENTITY_PLAYER_H
#define ATLAS_OBJECTS_ENTITY_PLAYER_H

#include <Atlas/Objects/Entity/Account.h>


namespace Atlas { namespace Objects { namespace Entity { 

/** Player accounts

Later in hierarchy tree objtype changes to 'object' when actual game objects are made.

*/
class Player : public Account
{
  public:
    /// Construct a Player instance.
    Player();
  protected:
    /// Constructor for sub-classes.
    Player(const char *,const char *);
  public:
    /// Default destructor.
    virtual ~Player();

    /// Create a new class for Player.
    static Player Class();

    /// Check whether the attribute "name" exists.
    virtual bool hasAttr(const std::string& name)const;
    /// Retrieve the attribute "name". Throws NoSuchAttrException if it does
    /// not exist.
    virtual Atlas::Message::Element getAttr(const std::string& name)
            const throw (NoSuchAttrException);
    /// Set the attribute "name" to the value given by"attr"
    virtual void setAttr(const std::string& name,
                         const Atlas::Message::Element& attr);
    /// Remove the attribute "name". This will not work for static attributes.
    virtual void removeAttr(const std::string& name);

    /// Send the contents of this object to a Bridge.
    virtual void sendContents(Atlas::Bridge* b) const;

    /// Convert this object to a Message::Element.
    virtual Atlas::Message::Element asObject() const;

    /// Convert this object to a Message::Element::MapType.
    virtual Atlas::Message::Element::MapType asMap() const;

    /// Set the "characters" attribute.
    inline void setCharacters(const Atlas::Message::Element::ListType& val);

    /// Retrieve the "characters" attribute.
    inline const Atlas::Message::Element::ListType& getCharacters() const;
    /// Retrieve the "characters" attribute as a non-const reference.
    inline Atlas::Message::Element::ListType& getCharacters();

protected:
    Atlas::Message::Element::ListType attr_characters;

    inline void sendCharacters(Atlas::Bridge*) const;

};

//
// Inlined member functions follow.
//

void Player::setCharacters(const Atlas::Message::Element::ListType& val)
{
    attr_characters = val;
}

const Atlas::Message::Element::ListType& Player::getCharacters() const
{
    return attr_characters;
}

Atlas::Message::Element::ListType& Player::getCharacters()
{
    return attr_characters;
}


} } } // namespace Atlas::Objects::Entity

#endif // ATLAS_OBJECTS_ENTITY_PLAYER_H
