------------------------------------------------------------------------------
--                                                                          --
--                      GNAT METRICS TOOLS COMPONENTS                       --
--                                                                          --
--                      M E T R I C S . S T R I N G S                       --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 15038 $
--                                                                          --
--                       Copyright (C) 2002, ACT Europe                     --
--                                                                          --
-- GNAT Metrics Toolset  is free software;  you can  redistribute it and/or --
-- modify it under terms of the  GNU General Public License as published by --
-- the Free Software Foundation;  either version 2, or (at your option) any --
-- later version.  GNAT Metrics Toolset is  distributed in the hope that it --
-- will be useful, but  WITHOUT ANY WARRANTY; without even the implied war- --
-- ranty of  MERCHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the --
-- GNU General Public License for more details.  You should have received a --
-- copy of the  GNU General Public License distributed with  GNAT; see file --
-- COPYING.  If not,  write to the  Free  Software  Foundation,   59 Temple --
-- Place - Suite 330, Boston,                                               --
--                                                                          --
-- GNAT Metrics Toolset is maintained by ACT Europe                         --
-- (http://www.act-europe.fr).                                              --
--                                                                          --
------------------------------------------------------------------------------

--  This package provides the efficient string storage mechanism for varied
--  length strings

package METRICS.Strings is

   type String_Loc is record
      First, Last : Natural;
   end record;
   --  This record contains the start and end positions of a string inside
   --  a character table

   Nil_String_Loc : String_Loc := (0, 0);
   --  Corresponds to an empty string

   function Enter_String (S : String) return String_Loc;
   --  Stores a string in a character array, returning its starting and ending
   --  positions in a String_Loc structure

   function Get_String (SL : String_Loc) return String;
   --  Retrieves a string from a character array, based on its starting
   --  and ending positions supplied by SL

   procedure Init;
   --  Resets the string table

end METRICS.Strings;
