/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */


#ifndef HAS_MISCFUNCTIONS_H
	#define HAS_MISCFUNCTIONS_H
	
#include <mimelib/string.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qfont.h>
#include <mailclasses.h>
#include <qcombobox.h>

class IndexClass;

void ElimComments (DwString dws);
void MakeLongLines(DwString dw);
int StripQuotes(DwString *msg, char *quotes);
void fit_text(QString &srctext, QString &desttext, int size, const QFont &font);
DwString *getBodyMessage(IndexClass *Index);
void ElimComments (DwString dws);
void MakeLongLines(DwString dw);
int StripQuotes(DwString *msg, char *quotes);
void fit_text(QString &srctext, QString &desttext, int size, const QFont &font);
QStringList split(const char *s, char c);
QString join(QStringList s, QString separator=", ");
QString toString(QStringList &s);
void showFolderStatus(LocalMailFolder *folder);
const char *getMimeIcon(const char *mimetype);
const char *getMimeType(const char *filename);
QCString translateString(QCString &name);

QStringList enhancedSplit(QString source, char split, QStringList escapes=QStringList());
QString remove(QString source, QString what, bool sensitive=false);

void MIMEfold(QString &str, int maxLength=73);
void MIMEunfold(QString &source);
void updateComboBox(QComboBox *box, QString item, bool addToBox=true);
QWidget *traceWindow(QWidget *currentWidget, QString name);


#endif








