/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <stdio.h>
#include <attendeelist.h>

#ifdef IDSTRING
	#undef IDSTRING
#endif
#define IDSTRING	"AttendeeList: "

#define DEBUG_ATTENDEELIST

AttendeeList::AttendeeList (MetaObject *mo)
{
	refreshAttendees(mo);
}
AttendeeList::~AttendeeList()
{
	clearAttendees();
}
void AttendeeList::refreshAttendees(MetaObject *mo)
{
	clearAttendees();
	if(!mo)
	{
		printf(IDSTRING"Warning: No attendees to be processed. List empty.\n");
		return;
	}
	QValueList<int> matches;
	matches=mo->query("ATTENDEE");
	for(int i=0;i<matches.count();i++)
		attendees.append(new Attendee(mo->getLines().at(matches[i])));
}
QValueList<Attendee *> AttendeeList::query(AttendeeList::FieldName fn, 
	QString fieldValue)
{
	QValueList<Attendee *> result;
	for(int i=0;i<attendees.count();i++)
	{
		bool toAdd=false;
		#define ati	attendees[i]
		switch(fn)
		{
			case AttendeeList::AttendeeField:
				if(ati->getAttendee().find(fieldValue,0,false)!=-1)
					toAdd=true;
				break;
			case AttendeeList::DelegatedFromField:
				if(attendees[i]->getDelegatedFrom().find(fieldValue,0,false)!=-1)
					toAdd=true;
				break;
			case AttendeeList::DelegatedToField:
				if(attendees[i]->getDelegatedTo().find(fieldValue,0,false)!=-1)
					toAdd=true;
				break;
			case AttendeeList::SentByField:
				if(attendees[i]->getAttendee().find(fieldValue,0,false)!=-1)
					toAdd=true;
				break;
			case AttendeeList::DirectoryField:
				if(attendees[i]->getDirectory().find(fieldValue,0,false)!=-1)
					toAdd=true;
				break;
			case AttendeeList::LanguageField:
				if(attendees[i]->getLanguage().find(fieldValue,0,false)!=-1)
					toAdd=true;
				break;
			case AttendeeList::CalUserTypeField:
				if(attendees[i]->getCalUserType().find(fieldValue,0,false)!=-1)
					toAdd=true;
				break;
			case AttendeeList::MembersField:
				printf(IDSTRING"Members query is not implemented yet\n");
				break;
			case AttendeeList::PartStatField:
				if(attendees[i]->getPartStat().find(fieldValue,0,false)!=-1)
					toAdd=true;
				break;
			case AttendeeList::RoleField:
				if(attendees[i]->getRole().find(fieldValue,0,false)!=-1)
					toAdd=true;
				break;
			case AttendeeList::RsvpField:
				if(((attendees[i]->getRsvp())?"TRUE":"FALSE")==fieldValue)
					toAdd=true;
				break;
		}
		if(toAdd)
			result.append(attendees[i]);
	}
	return result;
}


void AttendeeList::clearAttendees()
{
	for(int i=0;i<attendees.count();i++)
		delete attendees[i];
	attendees.clear();
}





