/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <kiconloader.h>

#include <qcstring.h>
#include <qstring.h>

#include <maillabel.h>
#include <mimelib/string.h>
#include <messageclass.h>
#include <conversions.h>
#include <videotoolbox.h>
#include <mailobj.h>
#include <clientvfs.h>
#include <mailview.h>

MailLabel::MailLabel(MailView *parent, const char *name):QWidget(parent, name)
{
	setFixedHeight(55);
	FromLabel=new TextLabel(this);
	SubjectLabel=new TextLabel(this);
	ToLabel=new TextLabel(this);
	CcLabel=new TextLabel(this);
	NothingLabel=new TextLabel(this);
	FromText=new QLabel(this);
	SubjectText=new QLabel(this);
	ToText=new QLabel(this);
	CcText=new QLabel(this);
	FromLabel->setAlignment(AlignLeft);
	ToLabel->setAlignment(AlignLeft);
	CcLabel->setAlignment(AlignLeft);
	SubjectLabel->setAlignment(AlignLeft);
	NothingLabel->setAlignment(AlignCenter);
	
	QFont f(font());
	f.setBold(true);
	fm = new QFontMetrics(f);
	
	FromText->setFont(f);
	ToText->setFont(f);
	CcText->setFont(f);
	SubjectText->setFont(f);
	
	FromText->setText("From:");
	ToText->setText("To:");
	SubjectText->setText("Subject:");
	CcText->setText("Cc:");
	NothingLabel->setText("No item selected");
	
	f.setBold(false);
	
	FromLabel->setFont(f);
	ToLabel->setFont(f);
	CcLabel->setFont(f);
	SubjectLabel->setFont(f);
	NothingLabel->setFont(f);
	
	FromText->setGeometry(5, 5, fm->width("From:"), fm->height());
	ToText->setGeometry(5, 25, fm->width("To:"), fm->height());
	SubjectText->setGeometry((width()-105)/2+5, 5, fm->width("Subject:"), fm->height());
	CcText->setGeometry((width()-105)/2+5, 25, fm->width("Cc:"), fm->height());
	NothingLabel->setGeometry(0, 0, width(), height());
	h_line=new QFrame(this);
	h_line->setFrameStyle(QFrame::HLine|QFrame::Sunken);
	h_line->setLineWidth(1);
	h_line->setGeometry(0, 50, parent->width(), 2);
	h_line->show();
	NothingLabel->show();
	
	attbutton=new EButton(this, "attachment button");
	attbutton->setNormalPixmap(BarIcon("attach-normal"));
	attbutton->setFocusPixmap(BarIcon("attach-focus"));
	attbutton->setClickedPixmap(BarIcon("attach-clicked"));
	attbutton->setGeometry(parent->width()-65, 0, 40, 40);
	
	address="";

	connect(attbutton, SIGNAL(clicked()), parent, SLOT(togglePane()));
		
	showDefault();
}

void MailLabel::setAddress(QString addr)
{
	if(addr.isEmpty())
	{
		showDefault();
		return;
	}

// I deleted the next line for IMAP
//	if(addr==address) return;
	
	address=addr;
	int attachments=0;

	MailObject *item=(MailObject *)ClientVFS::thisInstance()->objectRef(address);			
  
	if(item)
	{
 		FromLabel->setText((QCString)item->from());
 		ToLabel->setText((QCString)item->to());
 		SubjectLabel->setText(item->subject());
 		CcLabel->setText((QCString)item->cc());
		attachments=item->attachments();
	}

	FromText->setGeometry(5, 5, fm->width("From:"), fm->height());
	ToText->setGeometry(5, 25, fm->width("To:"), fm->height());
	SubjectText->setGeometry((width()-105)/2+5, 5, fm->width("Subject:"), fm->height());
	CcText->setGeometry((width()-105)/2+5, 25, fm->width("Cc:"), fm->height());
	
	FromLabel->setGeometry(10+FromText->width(), 5, (width()-105)/2-fm->width("From:")-10,
			fm->height());
	ToLabel->setGeometry(10+ToText->width(), 25, (width()-105)/2-fm->width("To:")-10,
			fm->height());
	SubjectLabel->setGeometry((width()-105)/2+10+SubjectText->width(), 5,
			(width()-105)/2-fm->width("Subject:")-10, fm->height());
	CcLabel->setGeometry((width()-105)/2+10+CcText->width(), 25,
			(width()-105)/2-fm->width("Cc:")-10, fm->height());
	h_line->setGeometry(0, 50, parentWidget()->width(), 2);
	attbutton->setGeometry(parentWidget()->width()-65, 0, 40, 40);

	FromText->show();
	ToText->show();
	SubjectText->show();
	CcText->show();
	FromLabel->show();
	ToLabel->show();
	SubjectLabel->show();
	CcLabel->show();
	
	NothingLabel->hide();
	
	if(attachments) attbutton->show();
	else attbutton->hide();
	
	((MailView *)parent())->hideAttachmentPane();
}

void MailLabel::resizeEvent(QResizeEvent *)
{
	if(address.isEmpty())
	{
		NothingLabel->setGeometry(0, 0, width(), height());
	}
	else
	{
		FromText->move(5, 5);
		ToText->move(5, 25);
		SubjectText->move((width()-105)/2+5, 5);
		CcText->move((width()-105)/2+5, 25);
		h_line->setGeometry(0, 50, width(), 2);

		FromLabel->setGeometry(5+FromText->width(), 5, (width()-105)/2-fm->width("From:")-5,
				fm->height());
		ToLabel->setGeometry(5+ToText->width(), 25, (width()-105)/2-fm->width("To:")-5,
				fm->height());
		SubjectLabel->setGeometry((width()-105)/2+5+SubjectText->width(), 5,
				(width()-105)/2-fm->width("Subject:")-5, fm->height());
		CcLabel->setGeometry((width()-105)/2+5+CcText->width(), 25,
				(width()-105)/2-fm->width("Cc:")-5, fm->height());
		attbutton->setGeometry(width()-65, 0, 40, 40);
	}
}

void MailLabel::showDefault()
{
  FromLabel->hide();
  ToLabel->hide();
  CcLabel->hide();
  SubjectLabel->hide();
	FromText->hide();
	ToText->hide();
	SubjectText->hide();
	CcText->hide();
	attbutton->hide();
	h_line->setGeometry(0, 50, parentWidget()->width(), 2);
	
	NothingLabel->show();
}

QString MailLabel::getAddress()
{
	return address;
}
