/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <cardview.h>
#include <kconfig.h>
#include <qdict.h>
#include <vcard.h>
#include <cardtilewidget.h>
#include <cardlistview.h>
#include <mailer.h>
#include <templateview.h>
#include <miscfunctions.h>
#include <vfolder.h>
#include <datahandlerimpl.h>

extern KConfig *GlobalConfig;

CardView::CardView(VFolder *vfolder, QWidget *parent, const char *name):QWidget(parent, name), TemplateView(vfolder), DataHandlerImpl()
{
	_folder=vfolder;
  main_layout=new QHBoxLayout(this);
  listView=new CardListView(vfolder, this);
  cardHeading=new CardHeading(this);
  cardHeading->setFixedWidth(40);
  tileView=new CardTileView(vfolder, this);
  tileView->setChildFixedHeight(false);
  tileView->enableWidthResize(true);
  tileView->viewport()->setBackgroundColor(QColor("white"));
  tileView->setChildWidth(250);
  tileView->setChildType(contacts);
  tileView->setXSpacing(10);
  tileView->setYSpacing(10);
  listView->hide();
  tileView->hide();
  
  connect(cardHeading, SIGNAL(clicked(const QString&)), tileView, SLOT(setStartView(const QString&)));

  GlobalConfig->setGroup("Contacts");
  if(GlobalConfig->readEntry("View mode")=="list")
  {
    mode=List;
    main_layout->addWidget(listView);
    main_layout->addWidget(cardHeading);
    listView->show();
    main_layout->activate();
  }
  else
  {
    mode=Tile;
    main_layout->addWidget(tileView);
    main_layout->addWidget(cardHeading);
    tileView->show();
    main_layout->activate();
  }
}

VFolder *CardView::vFolder()
{
	return _folder;
}

CardView::~CardView()
{
  delete(main_layout);
  delete(listView);
  delete(tileView);
}

void CardView::toggleDisplayMode()
{
  GlobalConfig->setGroup("Contacts");
  if(mode==List)
  {
    GlobalConfig->writeEntry("View mode", "tile");
    listView->hide();
    mode=Tile;
    delete(main_layout);
    main_layout=new QHBoxLayout(this);
    main_layout->addWidget(tileView);
    tileView->show();
    main_layout->activate();
  }
  else
  {
    GlobalConfig->writeEntry("View mode", "list");
    tileView->hide();
    mode=List;
    delete(main_layout);
    main_layout=new QHBoxLayout(this);
    main_layout->addWidget(listView);
    listView->show();
    main_layout->activate();
  }
}

CardListView *CardView::getListView()
{
	return listView;
}

CardTileView *CardView::getTileView()
{
	return tileView;
}

void CardView::newObject()
{
	if(mode==List) listView->newObject();
	else tileView->newObject();
}

void CardView::deleteSelection()
{
	if(mode==List) listView->deleteSelection();
	else tileView->deleteSelection();
}

int CardView::copySelection()
{
	if(mode==List) return listView->copySelection();
	else return tileView->copySelection();
}

int CardView::cutSelection()
{
	if(mode==List) return listView->cutSelection();
	else return tileView->cutSelection();
}

void CardView::moveSelectionTo()
{
	if(mode==List) listView->moveSelectionTo();
	else tileView->moveSelectionTo();
}

void CardView::copySelectionTo()
{
	if(mode==List) listView->copySelectionTo();
	else tileView->copySelectionTo();
}

void CardView::paste()
{
	if(mode==List) listView->paste();
	else tileView->paste();
}

void CardView::selectAll()
{
	if(mode==List) listView->QListView::selectAll(true);
	else tileView->selectAll();
}
