/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */                                                                               

#include <cardheading.h>
#include <stdio.h>

#include <qlayout.h>

#define DEBUG_CARD_HEADING

CardHeadingButton::CardHeadingButton( const QString& text, const QString& x_, CardHeading* parent, const char* name )
: QPushButton(text,parent,name), x(x_)
{
  connect(this,SIGNAL(activate(const QString&)),parent,SLOT(buttonActivated(const QString&)));
  connect(this,SIGNAL(clicked()),SLOT(clicked()));
  setFixedSize(38,20);
}

CardHeadingButton::~CardHeadingButton()
{
}
void CardHeadingButton::clicked()
{
  emit activate(x);
}

// this array contains the prefix letter usage statistics

int ustat[26]={  51 /*A*/, 48 /*B*/, 78 /*C*/, 41 /*D*/, 28 /*E*/, 38 /*F*/, 30 /*G*/, 33 /*H*/, 26 /*I*/,
                 10 /*J*/,  9 /*K*/, 29 /*L*/, 45 /*M*/, 18 /*N*/, 21 /*O*/, 76 /*P*/,  5 /*Q*/, 44 /*R*/,
                110 /*S*/, 46 /*T*/, 15 /*U*/, 12 /*V*/, 29 /*W*/,  1 /*X*/,  4 /*Y*/, 3 /*Z*/};

CardHeading::CardHeading(QWidget *parent, const char *name):QWidget(parent, name)
{
  buttonList.setAutoDelete(false);
  layout = 0L;

  setFixedWidth(40);
}

CardHeading::~CardHeading()
{
}

void CardHeading::resizeEvent(QResizeEvent *e)
{
#ifdef DEBUG_CARD_HEADING
  printf("Resize event received. New height:%d\n", e->size().height());
#endif
  
  QWidget::resizeEvent(e);
  static int oldBtnCount;

  // find out the new number of buttons
  int n=height()/20;
  n=n>27?27:n;
  
  if(n==oldBtnCount)
    return;

#ifdef DEBUG_CARD_HEADING
  printf("Computing structure for %d buttons..\n", n);
#endif

  buttonList.setAutoDelete(true);
  buttonList.clear();
  buttonList.setAutoDelete(false);

  if (layout)
    delete layout;
  layout = new QVBoxLayout(this,2,0);

  CardHeadingButton *nlabel=new CardHeadingButton("1,2,3", "1", this);
  layout->addWidget(nlabel);
  buttonList.append(nlabel);

  float totalWeight=0, currentWeight=0, groupWeight;

  for(int i=0;i<26;i++)
    totalWeight+=ustat[i];

  groupWeight=n>26?0:totalWeight/(n-1);

  QStringList lgroup;
  QString ltxt;
  int k=0;

  while(k<26)
  {
    // add letter to the existing group
    lgroup.append(QString(QChar(k+97)));
    currentWeight+=ustat[k];
    if(currentWeight>=groupWeight)
    {
      // make a new group
      if(lgroup.count()>3)
        ltxt=lgroup.first()+"-"+lgroup.last();
      else
//      {
        ltxt=lgroup.join(",");
//        for(int i=0;i<lgroup.count();i++)
//          ltxt+=lgroup[i]+",";
//        ltxt.remove(ltxt.length()-1, 1);
//      }

      CardHeadingButton *label=new CardHeadingButton(ltxt, lgroup.first(), this);
      layout->addWidget(label);
      buttonList.append(label);
      ltxt="";
      lgroup.clear();
      currentWeight=0;
    }
    k++;
  }

  if(!ltxt.isEmpty())
  {
    // make a new group
    if(lgroup.count()>3)
      ltxt=lgroup.first()+"-"+lgroup.last();
    else
//    {
      ltxt=lgroup.join(",");
//      for(int i=0;i<lgroup.count();i++)
//        ltxt+=lgroup[i]+",";
//      ltxt.remove(ltxt.length()-1, 1);
//    }
    CardHeadingButton *label=new CardHeadingButton(ltxt, lgroup.first(), this);
    layout->addWidget(label);
    buttonList.append(label);
  }

  for(int i=0;i<buttonList.count();i++)
    buttonList.at(i)->show();

  oldBtnCount=n;
}

void CardHeading::buttonActivated(const QString& x)
{
  debug(x);
  emit clicked(x);
}
