/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <qfiledialog.h>
#include <qlabel.h>
#include <qfile.h>
#include <qcstring.h>
#include <qmessagebox.h>
#include <kmimetype.h>
#include <kiconloader.h>
#include <mainwindow.h>
#include <attachmentpane.h>
#include <attachmentpanewidget.h>
#include <partobj.h>
#include <tilewidget.h>

AttachmentPaneWidget::AttachmentPaneWidget(PartObject *item, AttachmentPane *parent, const char *name):TileWidget(parent, name), TextFitter(), TemplateView(item)
{
  // set widget appearance
  setFixedSize(100, 70);
	
	_pixmap=new QLabel(this);
	_name=new QLabel(this);

  _pixmap->move(34, 10);
  _pixmap->setFixedSize(32, 32);
  _pixmap->setBackgroundColor(QColor("white"));
  _name->setFont(QFont("helvetica", 10));
  _name->setAlignment(AlignCenter);
  _name->setBackgroundColor(QColor("white"));
  _name->setFixedSize(80, 14);
  _name->move(10, 46);
  setBackgroundColor(QColor("white"));
  
  // enable event filtering
  installEventFilter(parent);
  _name->installEventFilter(parent);
  _pixmap->installEventFilter(parent);
	
	item->addView(this);
	
	update();
}

void AttachmentPaneWidget::update()
{
	PartObject *item=(PartObject *)getVItem();
	
	if(item)
	{
		QString attachmentIconType=KMimeType::mimeType(item->mimeType())->icon(QString::null, true);
		QPixmap attachmentIcon=DesktopIcon(attachmentIconType);

		QString displayedName=item->filename();
		if(displayedName.isEmpty()) displayedName="unknown";

  	displayedName=fitText(displayedName, 80, QFont("helvetica", 10, QFont::Bold));

		_name->setText(displayedName);
		_pixmap->setPixmap(attachmentIcon);
	}
}

AttachmentPaneWidget::~AttachmentPaneWidget()
{
}

void AttachmentPaneWidget::setState(ViewState state)
{
	DataWidget::setState(state);
 	
 	if(state==Selected)
		_name->setFont(QFont("helvetica", 10, QFont::Bold));
	else
		_name->setFont(QFont("helvetica", 10, QFont::Normal));

  _name->repaint();
}

void AttachmentPaneWidget::save()
{
	PartObject *item=(PartObject *)getVItem();
	
	if(item)
	{
		QString fileName=QFileDialog::getSaveFileName(item->filename());
		if(!fileName.isEmpty())
		{
			bool shouldSave=true;
			
			if(QFile::exists(fileName) && QMessageBox::information(MainWindow::ref(), "Aethera: File already exists",
						"The file you have selected already exists.\nDo you want to overwrite it?",
						QMessageBox::Yes, QMessageBox::No)==QMessageBox::No) shouldSave=false;
			
			if(shouldSave)
			{
				QFile saveFile(fileName);
				if(saveFile.open(IO_WriteOnly))
				{
					QByteArray data=item->data();
					saveFile.writeBlock(data.data(), data.size());
					saveFile.close();
				}
				else
				{
					QMessageBox::warning(MainWindow::ref(), "Aethera: Could not save",
							"The file could not be opened for writing.\nPlease check the directory permissions.\n",
							QMessageBox::Ok, QMessageBox::NoButton);
				}
			}
		}
	}
	else
	{
		QMessageBox::warning(MainWindow::ref(), "Aethera: Could not save",
				"Could not retrieve the attachment object.\nPlease restart the application and try again.\n",
				QMessageBox::Ok, QMessageBox::NoButton);
	}
}

void AttachmentPaneWidget::editProperties()
{
}
