/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

/** Changed by Eugen C. - 04 July 2001 */

#include <datahandler.h>
#include <clipboard.h>

extern ClipboardWrapper *Clipboard;

DataHandler::DataHandler()
{
  lastID=-1;
  ClipboardWrapper::thisInstance()->registerDataHandler(this);
	childViews.setAutoDelete(false);
}

DataHandler::~DataHandler()
{
  ClipboardWrapper::thisInstance()->cancelClipboardOperation(lastID);
  ClipboardWrapper::thisInstance()->unregisterDataHandler(this);
}

void DataHandler::clipboardOperationCompleted(int id)
{
  if(id!=lastID)
  {
    discardCut();
  }

  lastID=-1;
}

bool DataHandler::canPaste()
{
	int cid=ClipboardWrapper::thisInstance()->getLastID();
	
	if(lastID!=cid && cid!=-1 && ClipboardWrapper::thisInstance()->data())
	  return true;
	return false;
}

void DataHandler::grayOutSelection()
{
  lastID=copySelection();
	QList<DataWidget> selectionList=getSelection();
	
	for(QListIterator<DataWidget> it(selectionList); it.current(); ++it)
		(*it)->setState(DataWidget::GrayedOut);
}

void DataHandler::discardCut()
{
	for(QListIterator<DataWidget> it(childViews); it.current(); ++it)
		(*it)->setState(DataWidget::Normal);
}

DataWidget::ViewState DataHandler::state(DataWidget *w)
{
	return w->state();
}

void DataHandler::changeState(DataWidget *w, DataWidget::ViewState s)
{
	w->setState(s);
}

void DataHandler::selectAll()
{
	for(QListIterator<DataWidget> it(childViews); it.current(); ++it)
		(*it)->setState(DataWidget::Selected);
}

void DataHandler::unselectAll()
{
	for(QListIterator<DataWidget> it(childViews); it.current(); ++it)
		(*it)->setState(DataWidget::Normal);
}

bool DataHandler::isSelectionSingle()
{
	int selCount=0;
	
	for(QListIterator<DataWidget> it(childViews); it.current() && selCount<2; ++it)
		if( (*it)->state()==DataWidget::Selected )
		  selCount++;
	
	return selCount==1 ? true : false;
}

bool DataHandler::isSelectionMultiple()
{
	int selCount=0;
	
	for(QListIterator<DataWidget> it(childViews); it.current() && selCount<=2; ++it)
		if( (*it)->state()==DataWidget::Selected )
		  selCount++;
	
	return selCount==2 ? true : false;
}

bool DataHandler::isSelectionEmpty()
{
	int selCount=0;
	
	for(QListIterator<DataWidget> it(childViews); it.current() && !selCount; ++it)
		if( (*it)->state()==DataWidget::Selected )
		  selCount++;
	
	return selCount ? false : true;
}

void DataHandler::registerWidget(DataWidget *w)
{
	if(childViews.find(w)==-1)
	  childViews.append(w);
}

void DataHandler::unregisterWidget(DataWidget *w)
{
	childViews.removeRef(w);
}

QList<DataWidget> DataHandler::getSelection()
{
	QList<DataWidget> selectionList;
	
	for(QListIterator<DataWidget> it(childViews); it.current(); ++it)
	{
	  if( (*it)->state()==DataWidget::Selected )
			selectionList.append((*it));
	}
	
	return selectionList;
}

void DataHandler::select(DataWidget *w)
{
	if(w->state()!=DataWidget::Selected)
		w->setState(DataWidget::Selected);
	
	for(QListIterator<DataWidget> it(childViews); it.current(); ++it)
	{
		if( (*it)!=w && (*it)->state()!=DataWidget::Normal )
			(*it)->setState(DataWidget::Normal);
	}
}

void DataHandler::select(QList<DataWidget> &wList)
{
	for(QListIterator<DataWidget> it(childViews); it.current(); ++it)
	{
		if(wList.find((*it))!=-1 && (*it)->state()!=DataWidget::Selected)
			(*it)->setState(DataWidget::Selected);
		else if((*it)->state()!=DataWidget::Normal)
			(*it)->setState(DataWidget::Normal);
	}
}

void DataHandler::addToSelection(DataWidget *w)
{
	if(w->state()!=DataWidget::Selected)
		w->setState(DataWidget::Selected);
}

void DataHandler::addToSelection(QList<DataWidget> &wList)
{
	for(QListIterator<DataWidget> it(wList); it.current(); ++it)
	{
		if((*it)->state()!=DataWidget::Selected)
			(*it)->setState(DataWidget::Selected);
	}
}

void DataHandler::removeFromSelection(DataWidget *w)
{
	if(w->state()!=DataWidget::Normal)
		w->setState(DataWidget::Normal);
}

void DataHandler::removeFromSelection(QList<DataWidget> &wList)
{
	for(QListIterator<DataWidget> it(wList); it.current(); ++it)
	{
		if((*it)->state()!=DataWidget::Normal)
			(*it)->setState(DataWidget::Normal);
	}
}

