/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */


/*
This class offers a wrapper over the Qt clipboard, implementing two important features:

1) ability to activate/deactivate automatically UI controls depending on the clipboard contents
2) ability to work with classes inherited from DataHandler, which provides realistic cut/copy/paste and DnD features.

*/

#ifndef __ClipboardWrapper__
#define __ClipboardWrapper__

#include <qmime.h>
#include <qobject.h>
#include <qlist.h>
#include <datahandler.h>

class ClipboardWrapper : public QObject
{
  Q_OBJECT
	public:
		ClipboardWrapper();
		~ClipboardWrapper();

    // Returns an instance of the Clipboard    
    static ClipboardWrapper* thisInstance();
		
   // Registers a DataHandler object to syncronize cut&paste and DnD actions. This function should be called
    //  automatically by the DataHandler constructor.
    void registerDataHandler(DataHandler *h);
    
    // Removes the DataHandler object from the registration pool. This is automatically called by the DataHandler
		//  destructor.
    void unregisterDataHandler(DataHandler *d);
    
    // Allways use this function when pasting data, instead of QApplication::clipboard()->data().
		// Returns the mime-encapsulated data.
    QMimeSource *pasteData();
		
		// Returns the mime-encapsulated data.
		// Use this to check if your class can paste it.
		QMimeSource *data();
    
    // Allways use this function when copying data, instead of QApplication::clipboard()->setData().
    int copyData(QMimeSource *s);
    
    // Allways use this function when copying data, instead of QApplication::clipboard()->setData().
    int cutData(QMimeSource *s);
    
    // Call this function when you posses an operation ID and want to disable a cut, copy or drop.
    // Works only if the caller has the correct (i.e. current) id.
    void cancelClipboardOperation(int id);
		
		// last clipboard operation id
		int getLastID() { return lastID; }
		
		bool shouldCutSource() { return cutOperation; }
  public slots:
    void dataChanged();
  private:
    int lastID;   
    QList<DataHandler> hList;
    static ClipboardWrapper *inst;
		bool cutOperation;
};

#endif
