/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#ifndef __Has_CountriesClass__
#define __Has_CountriesClass__

#include <stdio.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qstringlist.h>

class CountriesClass
{
	public:
		enum { Mapped=1, Unmapped=2, Unique=4, All=7, AllUnique=6};
		CountriesClass(QString);
		QString country(QString, int extended=Mapped);
		QString domain (QString, int extended=Mapped);
		bool isCountry (QString, int extended=Mapped);
		bool isDomain  (QString, int extended=Mapped);
		QStringList &countries(int mapped=Unique);
		QStringList &domains  (int mapped=Unique);
		QStringList allCountries();
		QStringList allDomains  ();
		void add(QString, bool mapped=true);
		void load(QString);
		void save(QString);
		static CountriesClass *thisInstance(QString fname=QString::null);
	private:
		QStringList _mappedDomains;
		QStringList _mappedCountries;
		QStringList _unmappedDomains;
		QStringList _unmappedCountries;
		QStringList _uniqueCountries;
		QStringList _uniqueDomains;
		static CountriesClass *instCountries;
};

#endif
