/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <toobadframe.h>
#include <videotoolbox.h>
#include <definedmessages.h>

extern VideoToolBox vtb;

TooBadFrame::TooBadFrame(QWidget *parent, QString name,
	int x, int y, int dx, int dy, int idx) :
	QFrame(parent, name)
{
	index=idx;
	setGeometry(x, y, dx, dy);
	setFrameStyle(0);
	// Creating the continue-cancel buttons
	// The buttons are going to be in the bottom right
	int x,y;
	x=dx-80, y=dy-vtb.fontHeight();
	finishButton=vtb.setUpQPushButton(this,"Exit",
		80, vtb.fontHeight(), &x, &y);
		// create the frame!
	int DX=0, DY=0;
	tooBadView= vtb.setUpTextView(this, 0, backgroundColor(),
		"<center><b>The setup was cancelled.</b></center><br><br>"
		"&nbsp;&nbsp;&nbsp;&nbsp;Aethera Wizard will now exit. <br><br>"
		"&nbsp;&nbsp;&nbsp;&nbsp;No changes were made to the existing setup.<br><br>"
		"&nbsp;&nbsp;&nbsp;&nbsp;Press \"Exit\" to close this window.",
		dx,dy-vtb.fontHeight()-vtb.offsetY(),DX,DY);
	connect(finishButton, SIGNAL(clicked()), this, SLOT(finishClicked()));
}

void TooBadFrame::finishClicked()
{
	emit result(CancelMessage,index, QStringList(""));
	close();
}

