/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <smtpframe.h>
#include <videotoolbox.h>
#include <definedmessages.h>
#include <qdir.h>
#include <qfiledialog.h>
#include <names.h>

extern VideoToolBox vtb;

SMTPFrame::SMTPFrame(QWidget *parent, QString name,
	int x, int y, int dx, int dy, int idx) :
	QFrame(parent, name)
{
	index=idx;
	setGeometry(x, y, dx, dy);
	setFrameStyle(0);
	// Creating the continue-cancel buttons
	// The buttons are going to be in the bottom right
	int x,y;
	x=dx-280, y=dy-vtb.fontHeight();
	backButton=vtb.setUpQPushButton(this,"Back",
		80, vtb.fontHeight(), &x, &y);
	x=dx-180, y=dy-vtb.fontHeight();
	continueButton=vtb.setUpQPushButton(this,"Next",
		80, vtb.fontHeight(), &x, &y);
	continueButton->setDefault(true);
	x=dx-80, y=dy-vtb.fontHeight();
	finishButton=vtb.setUpQPushButton(this,"Cancel",
		80, vtb.fontHeight(), &x, &y);
	// create the text
	int DX=5, DY=5;
	vtb.setUpFonts(QFont("helvetica",12,QFont::Normal));
	text=vtb.setUpLabelSize(this,"Please type the SMTP server (outgoing mail)"
		" details.",
		dx-vtb.fontHeight()-10, &DX, &DY);
	DY=(dy-vtb.fontHeight()*2-DY)/2 +DY - vtb.fontHeight()/2;
	DX=5;
	smtpLabel=vtb.setUpLabel(this,"Server name:", &DX, &DY);
	smtpEdit=vtb.setUpLineEdit(this,
		dx-DX-vtb.stringLength("Port:")-55,vtb.fontHeight(), &DX, &DY);
	portLabel=vtb.setUpLabel(this,"Port:", &DX, &DY);
	portEdit=vtb.setUpLineEdit(this,50,vtb.fontHeight(), &DX, &DY);
	portEdit->setText("25");
	smtpEdit->setText(Names::systemSMTPServerName());
	connect(backButton, SIGNAL(clicked()), this, SLOT(backClicked()));
	connect(continueButton, SIGNAL(clicked()), this, SLOT(continueClicked()));
	connect(finishButton, SIGNAL(clicked()), this, SLOT(finishClicked()));
}
void SMTPFrame::continueClicked()
{
	QStringList rez;
	rez.append("[SMTP]");
	rez.append(QString("Server=")+smtpEdit->text());
	rez.append(QString("Port=")+portEdit->text());
	emit result(ContinueMessage, index, rez);
	close();
}

void SMTPFrame::finishClicked()
{
	emit result(CancelMessage, index, QStringList(""));
	close();
}

void SMTPFrame::backClicked()
{
	emit result(BackMessage, index, QStringList(""));
	close();
}
