/***************************************************************************
                  localmailfolder.h  -  the local mail folder class
                             -------------------
    begin                : Mon Mar  5 16:16:00 EET 2001
    copyright            : (C) 2001 by theKompany (www.thekompany.com>
    author               : Eugen Constantinescu
    email                : eug@thekompany.com
 ***************************************************************************/

#ifndef __LocalMailFolder__
#define __LocalMailFolder__

#include <qstring.h>
#include <qcstring.h>
#include <qdir.h>
#include <qstringlist.h>
#include <qdict.h>
#include <qlist.h>
#include <qmap.h>
#include <qdatetime.h>

#include <mailclasses.h>
#include <messageclass.h>
#include <mailfolder.h>

class LocalMailFolder : public MailFolder
{
	public:		
		LocalMailFolder(const QString &_storageDevice);
		~LocalMailFolder();

		// message file
		QString getMessagesFileName() const;
		
		// message generators
		IndexClass *createMessage(const QCString &text, const QCString &uid, const QDateTime &rcvtime,
		                          const QString &account=QString::null, MessageClass *parsedMessage = 0,
		                          bool bSync=false, const unsigned flags=0);
		
		// copy/move/delete/expunge
		IndexClass *copyMessage(IndexClass *);
		IndexClass *moveMessage(IndexClass *);
		bool deleteMessage(IndexClass *);
		bool expunge(bool force=false);

		/** sync the messages from the list.*/
		void sync();
	
	private: // methods
		void setupFiles();
		void loadIndex();
		bool shouldExpunge();
		
		// files
		QString messagesFileName;
};

#endif


