/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#ifndef __IndexClass__
#define __IndexClass__

#include <qlist.h>
#include <pthread.h>

class MimePart;
class QDataStream;
class QString;
class MailFolder;

class IndexClass
{
	friend QDataStream& operator>>(QDataStream &, IndexClass &);
	friend QDataStream& operator<<(QDataStream &, IndexClass &);
	public:
		IndexClass(MailFolder *parent=0, QString id=QString::null);
		IndexClass(IndexClass &);
		~IndexClass();
	
		QString getID() const;
		void setID(const QString &);
		
		QString getParentID() const;
		void setParentID(const QString &);
		
		QString getMessageID() const;
		void setMessageID(const QString &);
		
		bool getUnreadMark();
		void setUnreadMark(bool);
		
		MailFolder *getParentFolder() const;
		void setParentFolder(MailFolder *);
		
		/** Get the messages file name.*/
		QString getDataFilename() const;
		/** Get the descriptor file name.*/
		QString getDescriptorFileName() const;
	
		int getDescriptorOffset(void) const;
		void setDescriptorOffset(int);

		int getDescriptorLength(void) const;
		void setDescriptorLength(int);
				
		int getUniblockOffset() const;
		void setUniblockOffset(int);
		
		int getUniblockLength() const;
		void setUniblockLength(int);
		
		bool isMultipartOnly();
		void setMultipartOnly(bool);
		
		int getSize();
		
		int addPart(MimePart *, bool uniblockRelative=false);
		bool removePart(int);
		int getPartCount() const;
		MimePart *getPartAt(int);
		bool isFullMessage() const;
		
		bool isLocked();
		bool tryLock();
		void lock();
		void unlock();
	private:
		MailFolder *_parent;
		QString _id;
		QString _parentID;
		QString _messageID;
		int _descriptorOffset;
		int _descriptorLength;
		int _uniblockOffset;
		int _uniblockLength;
		QList<MimePart> _partList;
		int _multipartOnly;
		int _unreadMark;
		
		pthread_mutex_t _lock;
};

#endif


