/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#include <filefolder.h>
#include <qdir.h>
#include <qfile.h>
#include <qtextstream.h>
#include <transactionserver.h>
#include <conversions.h>

FileFolder::FileFolder(QString foldername, QString prefix):DataCollection(prefix)
{
  storageDevice=foldername;
  type=FolderStorage;
  buildEntryList();
}

FileFolder::~FileFolder()
{
}

void FileFolder::buildEntryList()
{
  QDir d(storageDevice);
  if(d.exists() && d.isReadable())
  {
    d.setFilter(QDir::Files | QDir::Readable | QDir::Writable | QDir::NoSymLinks);

    for(unsigned i=0;i<d.count();i++)
    {
      QString fname=d[i];
			
			if(isValidID(fname)) // we know we can't have two files with the same name in one folder, so we skip the existence test
			{
      	QFileInfo tinfo(d, fname);
      	ObjectReference *tobj=new ObjectReference;
				
				// set some object parameters
        tobj->filename=fname;
				tobj->id=fname;
        tobj->lastModified=tinfo.lastModified();
				tobj->length=tinfo.size();
			  tobj->offset=0;
				addEntry(tobj);

				// try to read the contents
        QFile tfile(d.path()+"/"+fname);
        if(tfile.open(IO_ReadOnly))
        {
					char *buf=new char[tobj->length];
					tfile.readBlock(buf, tobj->length);
					tobj->rawData.setRawData(buf, tobj->length);
          tfile.close();

					// debug
          printf("  -fileObject id: %s, device: %s\n", (const char *)tobj->id, (const char *)fname);
        }
				
				// set lastID accordingly
				unsigned long idNumber=fname.mid(idPrefix.length()).toULong();
				if(idNumber>lastIDNum)
					lastIDNum=idNumber;
			}
    }
  }
}

bool FileFolder::removeEntry(QString id, bool sync) // this is a file, removal is always synchronized (i.e. ignore the sync parameter)
{
  ObjectReference *t=ref(id);
  if(t)
  {
    objectList.remove(t);
    bool res=TransactionServer::thisInstance()->remove(t);
    delete(t);
    return res;
  }

  return false; // object does not exist
}

