/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <accounts.h>
#include <indexclass.h>
#include <outgoingmessage.h>
#include <qstring.h>
#include <qstringlist.h>
#include <addressclass.h>
#include <messageclass.h>
#include <messagedescriptor.h>
#include <messagedevice.h>
#include <messagefactory.h>
#include <mimecodec.h>
#include <stdio.h>

OutgoingMessage::OutgoingMessage(IndexClass *idx, Account *account)
{
	MessageDevice *dev=MessageFactory::thisInstance()->getMessage(idx);
	dev->loadDescriptor(false);
	MessageDescriptor &descriptor=dev->getDescriptor();
	message=MIMECodec::encodeEndLine(dev->rfc822Message());
	from=(const char *)((AddressClass)(const char *)descriptor.from).email;
	
	for(unsigned i=0;i<descriptor.to.count();i++)
		toAddresses.insert(toAddresses.begin(), (const char *)((AddressClass)(const char *)descriptor.to[i]).email);
	for(unsigned i=0;i<descriptor.cc.count();i++)
		toAddresses.insert(toAddresses.begin(), (const char *)((AddressClass)(const char *)descriptor.cc[i]).email);
	for(unsigned i=0;i<descriptor.bcc.count();i++)
		toAddresses.insert(toAddresses.begin(), (const char *)((AddressClass)(const char *)descriptor.bcc[i]).email);
	
	server=(const char *)account->smtp;
	port=account->s_port;
	speed=account->speed;
	
	// debug
	printf("ougoing message: [constructor] outgoing message created, length %d\n", message.length());
	
 	FILE *log=fopen("out.log", "wb");
 	fprintf(log, "%s", message.c_str());
 	fclose(log);
}
