/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */
 
#include <addressclass.h>
#include <qtextstream.h>
#include <qtextcodec.h>
#include <mimecodec.h>

AddressClass::AddressClass(const QCString &t)
{
  QTextStream txt(t, IO_ReadOnly);
  QCString token;
  txt>>token;
  while(!token.isEmpty())
  {
    if(email.find('@')==-1 && token.find('@')!=-1)
    {
      email=token;
      break;
    }
    if(email.isEmpty()) email=token;
    if(!name.isEmpty()) name+=' ';
    name.append(token);
    txt>>token;
  }
  
  stripEmail();
  stripName();
  translateName();
  
  if(name.isEmpty())
  {
    int pos=email.find('@');
    if(pos!=-1)
      name=email.left(pos);
    else
      name=email;
    translated_name=name;
  }
}

AddressClass::operator QCString()
{
  QCString t;
  if(!translated_name.isEmpty())
  {
    t.append("\"");
    t.append(translated_name);
    t.append("\"");
		t.append(email.isEmpty()?"":" ");
  }
	if(!email.isEmpty())
	{
  	t.append("<");
  	t.append(email);
  	t.append(">");
	}

  return t;
}

QCString AddressClass::toQCString()
{
	return operator QCString();
}

QCString AddressClass::getOriginalAddress()
{
  QCString t;
  if(!name.isEmpty())
  {
    t.append("\"");
    t.append(name);
    t.append("\" ");
  }
  t.append("<");
  t.append(email);
  t.append(">");

  return t;
}

void AddressClass::stripEmail()
{
  if(email.isEmpty()) return;
  if(email[0]=='<')
    email.remove(0, 1);
  if(email[email.length()-1]=='>')
    email.truncate(email.length()-1);
}

void AddressClass::stripName()
{
  unsigned index=0;
  while(index<name.length())
  {
    if(name[index]=='"')
      name.remove(index, 1);
    else
      index++;
  }
}

void AddressClass::translateName()
{
  translated_name=MIMECodec::translate(name);
}

QTextStream& operator<<(QTextStream &s, AddressClass &a)
{
  QCString t=(QCString)a;
  s<<t;
  return s;
}
