/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */
#include <outlookexpress.h>

//#define DEBUG_OUTLOOK_IMPORT



OutlookExpressImport::OutlookExpressImport(QString filename)
{
	f=NULL;
	setFile(filename);
}
void OutlookExpressImport::setFile(QString filename)
{
	if(f) fclose(f);
	if(filename!=QString::null) f=fopen((const char *)filename,"rb");
	if(f) readIndexes();
}

OutlookExpressImport::~OutlookExpressImport()
{
	if(f) fclose(f);
	messageHeaderList.clear();
}

unsigned OutlookExpressImport::getMessageSize(int messageNo)
{
	return messageHeaderList[messageNo].NextItemOffset;
}

QString OutlookExpressImport::getMessage(int messageNo)
{
	long bufsize= messageHeaderList[messageNo].NextItemOffset;
#ifdef DEBUG_OUTLOOK_IMPORT
	printf("Buffer size for message %d is %d\n",messageNo+1, bufsize);
#endif
	char *text;
	text=new char[bufsize+1];
	if(!text)
		return QString::null;
	fseek(f,messageHeaderList[messageNo].selfOffset,SEEK_SET);
	fread(text,bufsize,1,f);
	text[bufsize]=0;
#ifdef DEBUG_OUTLOOK_IMPORT
	printf("*************************** Message %4d of %4d\n",messageNo+1,
		messageHeaderList.count());
	printf("%s\n",text);
	printf("******************************************** END\n");
#endif
	QString result(text);
	delete text;
	return result;
	
}
QStringList	OutlookExpressImport::getAllMessages()
{
	QStringList result;
#ifdef DEBUG_OUTLOOK_IMPORT
	printf("getAllMessages");
#endif
	for(unsigned i=0;i<messageHeaderList.count();i++)
	{
		result.append(getMessage(i+1));
#ifdef DEBUG_OUTLOOK_IMPORT
		printf(".");
#endif
	}
#ifdef DEBUG_OUTLOOK_IMPORT
	printf("done\n");
#endif
	return result;
}

void OutlookExpressImport::readIndexes()
{
	char *buffer;
	int buffer_size=16;
	int red;
	OutlookMessageHeader omh;
	if(messageHeaderList.count()!=0) messageHeaderList.clear();
	// first, let's see which version is (if the file is really a outlook file)
	if(!f) return;
	if(!checkHeader()) return;
// jump to the first message header
// first 0x54 bytes are like a header (not important).
  fseek(f,(long)0x54,0);
	while(!feof(f))
	{
		buffer=new char[buffer_size];
		red=fread(buffer,buffer_size,1,f);
		if(red<1) break;
		memcpy(&omh,buffer+buffer_size-16,16);
		omh.selfOffset=ftell(f);
		buffer_size=omh.NextMessageText-omh.NextItemOffset;
		fseek(f,omh.NextItemOffset,SEEK_CUR);
		messageHeaderList.append(omh);
		delete buffer;
		buffer=NULL;
	}
	if(!buffer) delete buffer;
	buffer=NULL;
#ifdef DEBUG_OUTLOOK_IMPORT
	for(int i=0;i<messageHeaderList.count();i++)
	{
		printf("Message %5d: (%5d %5d %5d %5d) [%x %x %x %x]\n",
			i+1,
			messageHeaderList[i].MessageNumber, 
			messageHeaderList[i].NextMessageText, 
			messageHeaderList[i].NextItemOffset,
			messageHeaderList[i].selfOffset, 
			messageHeaderList[i].Unknown[0],
			messageHeaderList[i].Unknown[1],
			messageHeaderList[i].Unknown[2],
			messageHeaderList[i].Unknown[3]);
	}
#endif
}

bool OutlookExpressImport::checkHeader()
{
	char buf[0x54];
	fseek(f,0L,0);
	if(fread(buf,1,0x54,f)!=0x54)
		return false;
// probably the buf[0]...buf[3] checking should be eliminated
// it may have some connection with the outlook express version
	if(buf[0]!=0x4a && buf[1]!=0x4d && buf[2]!=0x46 && buf[3]!=0x36)
		return false;
	long filesize;
	memcpy(&filesize,buf+0x10,4);
	fseek(f,0L,SEEK_END);
#ifdef DEBUG_OUTLOOK_IMPORT
	printf(" filesize= %d, tell= %d\n",filesize,ftell(f));
#endif
	if(filesize!=ftell(f))
		return false;
	return true;
		
}






