/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#ifndef __Has_HtmlProcessing__
#define __Has_HtmlProcessing__

#include <qstringlist.h>

class HtmlProcessor
{
	public:
		static char *HtmlTag[];
	public:
		HtmlProcessor();
		void replaceURLs(QString url, QString &, QString href=QString::null, bool strict=false);
		void replaceEmails(QString &);
		static HtmlProcessor *thisInstance();
		// from old version
		void replaceHTMLTags(QString &str);
		void eliminateComments (QString &);
		void correctHTML (QString &);
		void removeTags (QString &);
		void removeHTMLTags(QString &);
	private:

		bool inHtml(QString &, int);
		void replaceChunk(QString &, QString url, QString href, bool strict=false);
		void replaceEmailChunk(QString &);
		void domainCheck(QString &, int &start, int &end, int urlLen, bool isMail=false);
		int wildcardFind(QString s, QString wildcard, int pos);
		int wildcardRfind(QString s, QString wildcard, int pos);
		
	private:
		static HtmlProcessor *hpInst;
		QStringList text;
		QStringList html;
		
		static QString VALID_ID_CHAR;
		static QString VALID_NAME_CHAR;
		static QString VALID_NAME_MAIL_CHAR;
		static QString EXT_NAME_CHAR;
		static QString NUMBER_CHAR;
};

#endif

