/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */
#include <addaddressesdialog.h>
#include <qstringlist.h>
#include <qlistview.h>
#include <qpushbutton.h>
#include <qheader.h>
#include <qcheckbox.h>

#include <addressbookview.h>
#include <addressclass.h>
#include <addresslistclass.h>
#include <ataddressbook.h>
#include <miscfunctions.h>

#include <stdio.h>

#define IDSTRING "AddAddressesDialog: "

//#define DEBUG_AAD

// it's a Modal dialog!
AddAddressesDialog::AddAddressesDialog(QWidget *parent, const char *name=0) : 
	AddAddressesDialogBase(parent, name, true)
{
#ifdef DEBUG_AAD
	printf(IDSTRING"Constructor start\n");
#endif
	toList->header()->hide();
	toList->setAllColumnsShowFocus(true);
	ccList->header()->hide();
	ccList->setAllColumnsShowFocus(true);
	bccList->header()->hide();
	bccList->setAllColumnsShowFocus(true);
#ifdef DEBUG_AAD
	printf(IDSTRING"Constructor set-up columns\n");
#endif	
	abView->initMode( AddressBook::Contacts | AddressBook::Groups);
	connect(deleteToButton, SIGNAL(clicked()), this, SLOT(deleteToClicked()));
	connect(deleteCcButton, SIGNAL(clicked()), this, SLOT(deleteCcClicked()));
	connect(deleteBccButton, SIGNAL(clicked()), this, SLOT(deleteBccClicked()));
	connect(toButton, SIGNAL(clicked()), this, SLOT(toClicked()));
	connect(ccButton, SIGNAL(clicked()), this, SLOT(ccClicked()));
	connect(bccButton, SIGNAL(clicked()), this, SLOT(bccClicked()));
	connect(okButton, SIGNAL(clicked()), this, SLOT(okClicked()));
	connect(cancelButton, SIGNAL(clicked()), this, SLOT(cancelClicked()));
#ifdef DEBUG_AAD
	printf(IDSTRING"Constructor end\n");
#endif
}

void AddAddressesDialog::setTo(AddressListClass *item)
{
	_to=item;
	if(!_to)
	{
		toFrame->setEnabled(false);
		return;
	}
	// get all the addresses from the list and put them in the listview
	for(int i=0;i<_to->count();i++)
	{
		_toList[0].append((const char *)(*item)[i].name);
		_toList[1].append((const char *)(*item)[i].email);
		populateList(toList, _toList[0], _toList[1]);
	}
}

void AddAddressesDialog::setCc(AddressListClass *item)
{
	_cc=item;
	if(!_cc)
	{
		ccFrame->setEnabled(false);
		return;
	}
	// get all the addresses from the list and put them in the listview
	for(int i=0;i<_cc->count();i++)
	{
		_ccList[0].append((const char *)(*item)[i].name);
		_ccList[1].append((const char *)(*item)[i].email);
		populateList(ccList, _ccList[0], _ccList[1]);
	}
}

void AddAddressesDialog::setBcc(AddressListClass *item)
{
	_bcc=item;
	if(!_bcc)
	{
		bccFrame->setEnabled(false);
		return;
	}
	// get all the addresses from the list and put them in the listview
	for(int i=0;i<_bcc->count();i++)
	{
		_bccList[0].append((const char *)(*item)[i].name);
		_bccList[1].append((const char *)(*item)[i].email);
		populateList(bccList, _bccList[0], _bccList[1]);
	}
}

void AddAddressesDialog::newDialog(AddressListClass *to, 
	AddressListClass *cc, 
	AddressListClass *bcc, 
	QWidget *parent=0)
{
	AddAddressesDialog *ad = new AddAddressesDialog(parent);
	ad->setTo(to);
	ad->setCc(cc);
	ad->setBcc(bcc);
	ad->show();
}

void AddAddressesDialog::bccClicked()
{
	QStringList selected;
	abView->getSelectedEmailList(selected);
	for(int i=0;i<selected.count();i++)
	{
		AddressClass *ac=new AddressClass((const char *)selected[i]);
		if(_bccList[1].findIndex((const char *)ac->email)==-1)
		{
			//add the new mail to the qstringlist
			_bccList[0].append((const char *)ac->name);
			_bccList[1].append((const char *)ac->email);
		}
		delete ac;
	}
	populateList(bccList, _bccList[0], _bccList[1]);
	if(dupesCheck->isChecked())
		checkDuplicates(_bccList[0], _bccList[1], _toList[0], _toList[1], _ccList[0], _ccList[1]);
}

void AddAddressesDialog::ccClicked()
{
	QStringList selected;
	abView->getSelectedEmailList(selected);
	for(int i=0;i<selected.count();i++)
	{
		AddressClass *ac=new AddressClass((const char *)selected[i]);
		if(_ccList[1].findIndex((const char *)ac->email)==-1)
		{
			//add the new mail to the qstringlist
			_ccList[0].append((const char *)ac->name);
			_ccList[1].append((const char *)ac->email);
		}
		delete ac;
	}
	populateList(ccList, _ccList[0], _ccList[1]);
	if(dupesCheck->isChecked())
		checkDuplicates(_ccList[0], _ccList[1], _toList[0], _toList[1], _bccList[0], _bccList[1]);
}


void AddAddressesDialog::toClicked()
{
	QStringList selected;
	abView->getSelectedEmailList(selected);
	for(int i=0;i<selected.count();i++)
	{
		AddressClass *ac=new AddressClass((const char *)selected[i]);
		if(_toList[1].findIndex((const char *)ac->email)==-1)
		{
			//add the new mail to the qstringlist
			_toList[0].append((const char *)ac->name);
			_toList[1].append((const char *)ac->email);
		}
		delete ac;
	}
	populateList(toList, _toList[0], _toList[1]);
	if(dupesCheck->isChecked())
		checkDuplicates(_toList[0], _toList[1], _ccList[0], _ccList[1], _bccList[0], _bccList[1]);
}

void AddAddressesDialog::deleteToClicked()
{
	QListViewItem *it= toList->firstChild();
	while(it)
	{
		if(it->isSelected())
			deleteItem(it->text(1),_toList[0], _toList[1]);
		it=it->nextSibling();
	}
	populateList(toList, _toList[0], _toList[1]);
}

void AddAddressesDialog::deleteCcClicked()
{
	QListViewItem *it= ccList->firstChild();
	while(it)
	{
		if(it->isSelected())
			deleteItem(it->text(1),_ccList[0], _ccList[1]);
		it=it->nextSibling();
	}
	populateList(ccList, _ccList[0], _ccList[1]);
}

void AddAddressesDialog::deleteBccClicked()
{
	QListViewItem *it= bccList->firstChild();
	while(it)
	{
		if(it->isSelected())
			deleteItem(it->text(1),_bccList[0], _bccList[1]);
		it=it->nextSibling();
	}
	populateList(bccList, _bccList[0], _bccList[1]);
}

void AddAddressesDialog::deleteItem(QString ocr, QStringList &name, QStringList &mail)
{
	int i=mail.findIndex(ocr);
	if(i==-1 || name.count()!=mail.count()) // then something is wrong... !
		return;
	mail.remove(mail.at(i));
	name.remove(name.at(i));
}

void AddAddressesDialog::deleteItem(int idx, QStringList &name, QStringList &mail)
{
	if(mail.count()<=idx || name.count()!=mail.count()) // then something is wrong... !
		return;
	mail.remove(mail.at(idx));
	name.remove(name.at(idx));
}

void AddAddressesDialog::populateList(QListView *list, QStringList name, QStringList mail)
{
	if(!list || name.count()!=mail.count())
		return;
	list->clear();
	for(int i=0;i<name.count();i++)
	{
		QListViewItem *it= new QListViewItem(list);
		it->setText(0,name[i]+"   ");
		it->setText(1,mail[i]);
	}
}

void AddAddressesDialog::checkDuplicates(QStringList &list10, QStringList &list11,
			QStringList &list20, QStringList &list21,
			QStringList &list30, QStringList &list31)
{
	bool altered=false;
	for(int i=0;i<list11.count();i++)
	{
		// check against list2
		int idx=list21.findIndex(list11[i]);
		if(idx!=-1)
		{
			altered=true;
			deleteItem(idx, list20, list21);
		}
		idx=list31.findIndex(list11[i]);
		if(idx!=-1)
		{
			altered=true;
			deleteItem(idx, list30, list31);
		}
	}
	if(altered)
	{
		populateList(toList, _toList[0], _toList[1]);
		populateList(ccList, _ccList[0], _ccList[1]);
		populateList(bccList, _bccList[0], _bccList[1]);
	}
}

QString AddAddressesDialog::makelist(QStringList names, QStringList emails)
{
	QStringList result;
	result.clear();
	for(int i=0;i<emails.count();i++)
	{
		result.append(QString("\"") + names[i] + QString("\" <") + emails[i] + QString(">"));
#ifdef DEBUG_AAD
		printf(IDSTRING"Address: [%s][%s]\n", (const char *)names[i], (const char *)emails[i]);
#endif
	}
	return result.join(", ");
}

void AddAddressesDialog::cancelClicked()
{
	close();
}

void AddAddressesDialog::okClicked()
{
	if(_to)
		(*_to)=AddressListClass((const char *)makelist(_toList[0], _toList[1]));
	if(_cc)
		(*_cc)=AddressListClass((const char *)makelist(_ccList[0], _ccList[1]));
	if(_bcc)
		(*_bcc)=AddressListClass((const char *)makelist(_bccList[0], _bccList[1]));
	close();
}
