/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#include <clientrmi.h>
#include <any.h>
#include <commands.h>
#include <rmicalldata.h>
#include <commframe.h>
#include <qstring.h>
#include <qstringlist.h>
#include <commbinder.h>
#include <conversions.h>
#include <clientvfs.h>

ClientRMI *ClientRMI::thisInstance;

ClientRMI *ClientRMI::ref()
{
	return thisInstance?(thisInstance=new ClientRMI()):thisInstance;
}

void ClientRMI::__RMICall(const RMICallData &data)
{
	CommFrame inFrame;
	
	inFrame.majorRevNo=1;
	inFrame.minorRevNo=1;
	inFrame.requestFrame=true;
	inFrame.clientFrame=true;
	inFrame.deniesReply=true;
	inFrame.hasData=true;
	inFrame.commandCode=MagellanComm::RMICall;
	
	inFrame.extraData=_stream(data);
	
	CommBinder::thisInstance()->send("thisInstance", inFrame);
}

Any ClientRMI::__RMICallback(const RMICallData &data)
{
	CommFrame inFrame, outFrame;
	
	inFrame.majorRevNo=1;
	inFrame.minorRevNo=1;
	inFrame.requestFrame=true;
	inFrame.clientFrame=true;
	inFrame.requestsReply=true;
	inFrame.hasData=true;
	inFrame.commandCode=MagellanComm::RMICall;
	
	inFrame.extraData=_stream(data);
	
	CommBinder::thisInstance()->send("thisInstance", inFrame, outFrame);
	
	return _narrowAny(outFrame.extraData);
}

void ClientRMI::__process(CommFrame &inFrame)
{
	RMICallData data=_narrowRMICallData(inFrame.extraData);
	
	if(data.method=="sendPOP3Progress(QString)")
	{
		sendPOP3Progress(data.param[0].toString());
	}
	else if(data.method=="sendSMTPProgress(QString)")
	{
		sendSMTPProgress(data.param[0].toString());
	}
}

void ClientRMI::__process(CommFrame &inFrame, CommFrame &outFrame)
{
	RMICallData data=_narrowRMICallData(inFrame.extraData);
	
	if(data.method=="getSMTPAction(QString,QString,int)")
	{
		outFrame.extraData=_stream(Any(getSMTPAction(data.param[0].toString(), data.param[1].toString(), (int)data.param[2])));
	}
	if(data.method=="getMailAccountPassword(QString)")
	{
		outFrame.extraData=_stream(Any(getMailAccountPassword(data.param[0].toString())));
	}
}

QStringList ClientRMI::getAccountNames(int accountType)
{
	RMICallData data;
	data.method="getAccountNames(int)";
	data.pcount=1;
	data.param.append(Any(accountType));
	return __RMICallback(data).toStringList();
}

QString ClientRMI::getDefaultAccount()
{
	RMICallData data;
	data.method="getDefaultAccount()";
	data.pcount=0;
	return __RMICallback(data).toString();
}

bool ClientRMI::isAccountActive(QString account)
{
	RMICallData data;
	data.method="isAccountActive(QString)";
	data.pcount=1;
	data.param.append(Any(account));
	return (int)__RMICallback(data);
}

QString ClientRMI::getAccountFromAddress(QString account)
{
	RMICallData data;
	data.method="getAccountFromAddress(QString)";
	data.pcount=1;
	data.param.append(Any(account));
	return __RMICallback(data).toString();
}

QString ClientRMI::getAccountReplyToAddress(QString account)
{
	RMICallData data;
	data.method="getAccountReplyToAddress(QString)";
	data.pcount=1;
	data.param.append(Any(account));
	return __RMICallback(data).toString();
}

void ClientRMI::startSendReceive(QString account)
{
	RMICallData data;
	data.method="startSendReceive(QString)";
	data.pcount=1;
	data.param.append(Any(account));
	__RMICall(data);
}

void ClientRMI::startSend(QString account)
{
	RMICallData data;
	data.method="startSend(QString)";
	data.pcount=1;
	data.param.append(Any(account));
	__RMICall(data);
}

void ClientRMI::startReceive(QString account)
{
	RMICallData data;
	data.method="startReceive(QString)";
	data.pcount=1;
	data.param.append(Any(account));
	__RMICall(data);
}

void ClientRMI::stopPOP3Delivery()
{
	RMICallData data;
	data.method="stopPOP3Delivery()";
	data.pcount=0;
	__RMICall(data);
}

void ClientRMI::setAutoExpunge(bool mode)
{
	RMICallData data;
	data.method="setAutoExpunge(bool)";
	data.pcount=1;
	data.param.append(Any(mode));
	__RMICall(data);
}

bool ClientRMI::mount(QString url)
{
	RMICallData data;
	data.method="mount(QString)";
	data.pcount=1;
	data.param.append(Any(ClientVFS::thisInstance()->map(url)));
	return __RMICallback(data).toInt();
}

bool ClientRMI::unmount(QString url)
{
	RMICallData data;
	data.method="unmount(QString)";
	data.pcount=1;
	data.param.append(Any(ClientVFS::thisInstance()->map(url)));
	return __RMICallback(data).toInt();
}

bool ClientRMI::subfolders(QString url)
{
 	int iFind1=0, iFind2=0;
  	
  //  folderPath=/Magellan/Mail/Account/Mailbox
  //  or
  //  folderPath=/Magellan/Mail/Account
  for(unsigned i=0; i<2 && iFind1!=-1; ++i)
    iFind1=url.find('/', iFind1+1);
  iFind2=url.find('/', iFind1+1);
  if( iFind1==-1 )
    return false;

	RMICallData data;
	data.method="subfolders(QString, QString, QString)";
	data.pcount=3;
  if( iFind2==-1 )
  {
  	data.param.append( Any(url.right( url.length() - (iFind1+1) )));
  	data.param.append( Any(QString("\"\"")) );
  	data.param.append( Any(QString("genmail")) );
  }
  else
  {
  	data.param.append( Any(url.mid( iFind1+1, iFind2-(iFind1+1) )));
  	data.param.append( Any(url.right( url.length()-(iFind2+1) )));
  	data.param.append( Any(QString("genmail")) );
  }

	return __RMICallback(data).toInt();
}











