/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */


#include <groupobj.h>
#include <qvariant.h>
#include <vobject.h>
#include <vobjectfactory.h>
#include <queryprocessor.h>
#include <kconfig.h>


#define IDSTRING "GroupObject: "

// #define DEBUG_GO

extern KConfig *GlobalConfig;

GroupObject::GroupObject(QString _path) : VObject(_path)
{
#ifdef DEBUG_GO
	printf(IDSTRING"constructor: syncing object...\n");
#endif	
	// restore the object properties from the server
  sync();
	
#ifdef DEBUG_GO
	printf(IDSTRING"contructor: done\n");
#endif
}

GroupObject::GroupObject(QString _path, QByteArray &_data) : VObject(_path)
{
#ifdef DEBUG_GO
	printf(IDSTRING"constructor: syncing object...\n");
#endif	
	// restore the object properties from the server
	if( !_data || !_data.size() )
	  sync();
	else
	  _narrow(_data);
	
#ifdef DEBUG_GO
	printf(IDSTRING"contructor: done\n");
#endif
}

GroupObject::~GroupObject()
{
#ifdef DEBUG_GO
	printf(IDSTRING"destructor: syncing object...\n");
#endif	
}
/**
 *	Methods for accessing the fields
 */
QString GroupObject::groupName()
{
	return _groupName;
}

void GroupObject::setGroupName(QString newName)
{
	_groupName=newName;
}

QStringList GroupObject::members()
{
	return _members;
}

void GroupObject::setMembers(QStringList newMembers)
{
	_members=newMembers;
}

QStringList GroupObject::classes()
{
	return _classes;
}

void GroupObject::setClasses(QStringList newClasses)
{
	_classes=newClasses;
}

QString GroupObject::icon()
{
	return _icon;
}

void GroupObject::setIcon(QString newIcon)
{
	_icon=newIcon;
}

QByteArray GroupObject::_stream()
{
	QByteArray tdata;
	QDataStream tstream(tdata, IO_WriteOnly);
	
	tstream << _groupName << _members << _classes << _category << _icon;
	
	return tdata;
}

void GroupObject::_narrow(const QByteArray &tdata)
{
	if(tdata.size())
	{
		QDataStream tstream(tdata, IO_ReadOnly);

		// unstream the object properties
		tstream >> _groupName >> _members >> _classes >> _category >> _icon;
#ifdef DEBUG_GO
		printf(IDSTRING"Object read : %d\n",tdata.size());
#endif
	}
	else
	{
		_groupName=_category=_icon="";
		_members=QStringList();
		_classes=QStringList();
		printf(IDSTRING"Empty object!\n");
	}
}


bool GroupObject::getProperty(QString query, Any &property)
{
	if(query=="groupname")
	{
		property=Any(_groupName);
		return true;
	}
	if(query=="members")
	{
		property=Any(_members);
		return true;
	}
	if(query=="classes")
	{
		property=Any(_classes);
		return true;
	}
	if(query=="icon")
	{
		property=Any(_icon);
		return true;
	}
	if(query=="category")
	{
		property=Any(_category);
		return true;
	}
	return false;
}
bool GroupObject::setProperty(QString query, Any &property)
{
	if(query=="groupname")
	{
		_groupName=property.toString();
		return true;
	}
	if(query=="members")
	{
		_members=property.toStringList();
		return true;
	}
	if(query=="classes")
	{
		_classes=property.toStringList();
		return true;
	}
	if(query=="icon")
	{
		_icon=property.toString();
		return true;
	}
	if(query=="category")
	{
		_category=property.toString();
		return true;
	}
	return false;
}

QueryProcessor::QueryType GroupObject::queryType(QString query)
{
	if(query=="name" || query=="classes" || query=="members" || query=="category")
		return QueryProcessor::ReadWriteQuery;
	return QueryProcessor::InvalidQuery;
}

GroupObject *GroupObjectFactory::_new(QString _path)
{
	return ClientVFS::thisInstance()->template _new<GroupObject>(_path);
}

GroupObject *GroupObjectFactory::_new(QString _path, QByteArray &_data)
{
	return ClientVFS::thisInstance()->template _new<GroupObject>(_path, _data);
}
