/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <qcheckbox.h>
#include <qcombobox.h>
#include <qstringlist.h>
#include <qstring.h>

#include <contactsconfigbase.h>
#include <contactsconfig.h>
#include <kconfig.h>
#include <stdio.h>

extern KConfig *GlobalConfig;

#define IDSTRING "ContactsConfig: "

ContactsConfig::ContactsConfig(QWidget *parent, const char *name) : ContactsConfigBase(parent, name)
{
	load();
}
void ContactsConfig::load()
{
	// get the name
	GlobalConfig->setGroup("Contacts");
	QString str=GlobalConfig->readEntry("View fields");
	QStringList s=QStringList::split(";",str);
	for(int i=0;i<s.count();i++)
	{
		QStringList list=QStringList::split("=",s[i]);
		if(list[0]=="name")
			loadName((list.count()==2)?list[1]:QString::null);
		else if(list[0]=="work address")
			loadWork((list.count()==2)?list[1]:QString::null);
		else if(list[0]=="home address")
			loadHome((list.count()==2)?list[1]:QString::null);
		else if(list[0]=="email")
			loadEmail((list.count()==2)?list[1]:QString::null);
		else if(list[0]=="phone")
			loadPhone((list.count()==2)?list[1]:QString::null);
	}
}

void ContactsConfig::loadName(QString str)
{
	if(str.isEmpty())
	{
		defaultCheck->setChecked(true);
		prefixCheck->setEnabled(false);
		surnameCheck->setEnabled(false);
		nameCheck->setEnabled(false);
		otherCheck->setEnabled(false);
		suffixCheck->setEnabled(false);
	}
	else
	{
		QStringList s=QStringList::split(",",str);
		defaultCheck->setChecked(false);
		if(s.findIndex("prefix")!=-1)
			prefixCheck->setChecked(true);
		if(s.findIndex("surname")!=-1)
			surnameCheck->setChecked(true);
		if(s.findIndex("name")!=-1)
			nameCheck->setChecked(true);
		if(s.findIndex("other")!=-1)
			otherCheck->setChecked(true);
		if(s.findIndex("suffix")!=-1)
			suffixCheck->setChecked(true);
	}
}

void ContactsConfig::loadWork(QString str)
{
	if(str.isEmpty())
	{
		wRegionCheck->setChecked(true);
		wExtendedCheck->setChecked(false);
		wPBCheck->setChecked(true);
		wCodeCheck->setChecked(true);
		wStreetCheck->setChecked(true);
		wCountryCheck->setChecked(true);
		wCityCheck->setChecked(true);
	}
	else
	{
		QStringList s=QStringList::split(",",str);
		if(s.findIndex("region")!=-1)
			wRegionCheck->setChecked(true);
		if(s.findIndex("extended")!=-1)
			wExtendedCheck->setChecked(true);
		if(s.findIndex("po-box")!=-1)
			wPBCheck->setChecked(true);
		if(s.findIndex("code")!=-1)
			wCodeCheck->setChecked(true);
		if(s.findIndex("street")!=-1)
			wStreetCheck->setChecked(true);
		if(s.findIndex("country")!=-1)
			wCountryCheck->setChecked(true);
		if(s.findIndex("city")!=-1)
			wCityCheck->setChecked(true);
	}
}

void ContactsConfig::loadHome(QString str)
{
	if(str.isEmpty())
	{
		hRegionCheck->setChecked(true);
		hExtendedCheck->setChecked(false);
		hPBCheck->setChecked(true);
		hCodeCheck->setChecked(true);
		hStreetCheck->setChecked(true);
		hCountryCheck->setChecked(true);
		hCityCheck->setChecked(true);
	}
	else
	{
		QStringList s=QStringList::split(",",str);
		if(s.findIndex("region")!=-1)
			hRegionCheck->setChecked(true);
		if(s.findIndex("extended")!=-1)
			hExtendedCheck->setChecked(true);
		if(s.findIndex("po-box")!=-1)
			hPBCheck->setChecked(true);
		if(s.findIndex("code")!=-1)
			hCodeCheck->setChecked(true);
		if(s.findIndex("street")!=-1)
			hStreetCheck->setChecked(true);
		if(s.findIndex("country")!=-1)
			hCountryCheck->setChecked(true);
		if(s.findIndex("city")!=-1)
			hCityCheck->setChecked(true);
	}
}

void ContactsConfig::loadEmail(QString str)
{
	// regardless of the garbage passed as parameter...
	emailCheck->setChecked(true);
}

void ContactsConfig::loadPhone(QString str)
{
	if(str.isEmpty())
	str = "default";
//	updateComboBox(phoneBox, str);
}


void ContactsConfig::sync(bool visible=false)
{
	bool doSync=(!visible && isVisible()) | (visible);
#ifdef DEBUG_CC
	printf(IDSTRING "Sync-ing...\n");
#endif
	if(!doSync)
		return;
	// do a sync...
	// build the stringlist containing all the elements...
	QStringList fields;
	QString field;
	if(defaultCheck->isChecked())
	{
		field="name";
	}
	else
	{
		field="name=";
		QStringList tlist;
		if(prefixCheck->isChecked()) tlist.append("prefix");
		if(nameCheck->isChecked()) tlist.append("name");
		if(surnameCheck->isChecked()) tlist.append("surname");
		if(otherCheck->isChecked()) tlist.append("other");
		if(suffixCheck->isChecked()) tlist.append("suffix");
		for(int i=0;i<tlist.count();)
			if(tlist[i].isEmpty())
				tlist.remove(tlist.at(i));
			else
				i++;
		field = field+tlist.join(",");
	}
	// if I have the name at all...
	if(defaultCheck->isChecked() || prefixCheck->isChecked() || nameCheck->isChecked() ||
		surnameCheck->isChecked() || otherCheck->isChecked() || suffixCheck->isChecked())
		fields.append(field);
	// the e-mail
	if(emailCheck->isChecked())
		fields.append("email");
	// the phone
	if(phoneBox->currentText()!="none")
	{
		if(phoneBox->currentText()=="default")
			fields.append("phone");
		else
			fields.append(QString("phone=")+phoneBox->currentText().lower());
	}
	// the work address
	if( wRegionCheck->isChecked() || wExtendedCheck->isChecked() || wPBCheck->isChecked() ||
		wCodeCheck->isChecked() || wStreetCheck->isChecked() || wCountryCheck->isChecked() ||
		wCityCheck->isChecked())
	{
		// check for default
		if(wRegionCheck->isChecked() && !wExtendedCheck->isChecked() && wPBCheck->isChecked() &&
			wCodeCheck->isChecked() && wStreetCheck->isChecked() && wCountryCheck->isChecked() &&
			wCityCheck->isChecked())
		{
			fields.append("work address");
		}
		else
		{
			fields.append(QString("work address=") + ((wPBCheck->isChecked())?"po-box":"") +
				((wStreetCheck->isChecked())?"street":"") +
				((wExtendedCheck->isChecked())?"extended":"") +
				((wCityCheck->isChecked())?"city":"") +
				((wRegionCheck->isChecked())?"region":"") +
				((wCodeCheck->isChecked())?"code":"") +
				((wCountryCheck->isChecked())?"country":""));
		}
	}
	// the work address
	if( hRegionCheck->isChecked() || hExtendedCheck->isChecked() || hPBCheck->isChecked() ||
		hCodeCheck->isChecked() || hStreetCheck->isChecked() || hCountryCheck->isChecked() ||
		hCityCheck->isChecked())
	{
		// check for default
		if(hRegionCheck->isChecked() && !hExtendedCheck->isChecked() && hPBCheck->isChecked() &&
			hCodeCheck->isChecked() && hStreetCheck->isChecked() && hCountryCheck->isChecked() &&
			hCityCheck->isChecked())
		{
			fields.append("home address");
		}
		else
		{
			fields.append(QString("home address=") + ((hPBCheck->isChecked())?"po-box":"") +
				((hStreetCheck->isChecked())?"street":"") +
				((hExtendedCheck->isChecked())?"extended":"") +
				((hCityCheck->isChecked())?"city":"") +
				((hRegionCheck->isChecked())?"region":"") +
				((hCodeCheck->isChecked())?"code":"") +
				((hCountryCheck->isChecked())?"country":""));
		}
	}
#ifdef DEBUG_CC
	printf(IDSTRING" Writing entries: [%s]\n", (const char *)fields.join(";"));
#endif
	GlobalConfig->setGroup("Contacts");
	for(int i=0;i<fields.count();)
	{
		if(fields[i].isEmpty())
			fields.remove(fields.at(i));
		else
			i++;
	}
	GlobalConfig->writeEntry("View fields", fields.join(";"));
	emit(noChanged());
}

void ContactsConfig::defaultFieldsClicked()
{
	if(defaultCheck->isChecked())
	{
		prefixCheck->setEnabled(false);
		surnameCheck->setEnabled(false);
		nameCheck->setEnabled(false);
		otherCheck->setEnabled(false);
		suffixCheck->setEnabled(false);
	}
	else
	{
		prefixCheck->setEnabled(true);
		surnameCheck->setEnabled(true);
		nameCheck->setEnabled(true);
		otherCheck->setEnabled(true);
		suffixCheck->setEnabled(true);
	}
	emit(changed());
}

void ContactsConfig::emailClicked()
{
	emit(changed());
}

void ContactsConfig::hCityClicked()
{
	emit(changed());
}

void ContactsConfig::hCodeClicked()
{
	emit(changed());
}

void ContactsConfig::hExtendedClicked()
{
	emit(changed());
}

void ContactsConfig::hPoBoxClicked()
{
	emit(changed());
}

void ContactsConfig::hRegionClicked()
{
	emit(changed());
}

void ContactsConfig::hStreetClicked()
{
	emit(changed());
}

void ContactsConfig::nameClicked()
{
	emit(changed());
}

void ContactsConfig::hCountryClicked()
{
	emit(changed());
}

void ContactsConfig::otherClicked()
{
	emit(changed());
}

void ContactsConfig::phoneChanged(const QString &)
{
	emit(changed());
}

void ContactsConfig::prefixClicked()
{
	emit(changed());
}

void ContactsConfig::suffixClicked()
{
	emit(changed());
}

void ContactsConfig::surnameClicked()
{
	emit(changed());
}

void ContactsConfig::wCityClicked()
{
	emit(changed());
}

void ContactsConfig::wCodeClicked()
{
	emit(changed());
}

void ContactsConfig::wCountryClicked()
{
	emit(changed());
}

void ContactsConfig::wExtendedClicked()
{
	emit(changed());
}

void ContactsConfig::wPoBoxClicked()
{
	emit(changed());
}

void ContactsConfig::wRegionClicked()
{
	emit(changed());
}

void ContactsConfig::wStreetClicked()
{
	emit(changed());
}

