/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <vattribute.h>
#include <vobject.h>
#include <vfolder.h>
#include <qstring.h>
#include <qcstring.h>
#include <commframe.h>
#include <statuscodes.h>
#include <qdatastream.h>
#include <clientvfs.h>

VAttribute::VAttribute(QString p)
 : VObject(p)
{
	// debug
	printf("vattribute constructor: %p\n", this);
}

VAttribute::VAttribute(QString p, QByteArray& _data)
 : VObject(p)
{
	// debug
	printf("vattribute constructor: %p\n", this);
}

void VAttribute::_narrow(const QByteArray &data)
{
	// debug
	printf("vattribute: unstreaming data...\n");

	if(data.size())
	{
		QDataStream inStream(data, IO_ReadOnly);

		// unstream the byte array
		QString _type;
		inStream>>_type>>owner>>device>>dtype>>rtype>>size>>lmodified>>active>>flags;
	}
	else
	{
		printf("warning: vattribute %s attempted to unstream an empty block, bailing out\n", (const char *)path());
	}
}

QByteArray VAttribute::_stream()
{
	QByteArray data;
	QDataStream outStream(data, IO_WriteOnly);
	
	// stream the attribute
	outStream<<"vattribute"<<owner<<device<<dtype<<rtype<<size<<lmodified<<active<<flags;
	
	return data;
}

bool VAttribute::getProperty(const QString &query, Any &property)
{
	if(query=="owner")
	{
		property=Any(owner);
		return true;
	}	
	if(query=="device")
	{
		property=Any(device);
		return true;
	}
	if(query=="dtype")
	{
		property=Any(dtype);
		return true;
	}
	if(query=="rtype")
	{
		property=Any(rtype);
		return true;
	}
	if(query=="size")
	{
		property=Any(size);
		return true;
	}
	if(query=="active")
	{
		property=Any(active);
		return true;
	}
	if(query=="lmodified")
	{
		property=Any(lmodified);
		return true;
	}
	if(query=="flags")
	{
		property=Any(flags);
		return true;
	}	
	
	return false;
}

bool VAttribute::setProperty(const QString &query, Any &property)
{
	return false;
}

QueryProcessor::QueryType VAttribute::queryType(const QString &query)
{
	if(query=="owner" || query=="device" || query=="dtype" || query=="rtype"
			|| query=="size" || query=="active" || query=="lmodified" || query=="flags")
		return QueryProcessor::ReadOnlyQuery;
	
	return QueryProcessor::InvalidQuery;
}
