/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.ElementImpl;
import org.w3c.dom.DOMException;

public class ElementNSImpl
extends ElementImpl {
    static final long serialVersionUID = -9142310625494392642L;
    static final String xmlURI = "http://www.w3.org/XML/1998/namespace";
    protected String namespaceURI;
    protected String localName;

    protected ElementNSImpl(DocumentImpl documentImpl, String string, String string2) throws DOMException {
        super(documentImpl, string2);
        int n = string2.indexOf(58);
        if (n < 0) {
            Object var5_5 = null;
            this.localName = string2;
        } else {
            String string3 = string2.substring(0, n);
            this.localName = string2.substring(n + 1);
            if (documentImpl.errorChecking) {
                if (string == null || this.localName.length() == 0 || this.localName.indexOf(58) >= 0) {
                    throw new DOMException(14, "DOM003 Namespace error");
                }
                if (string3.equals("xml") ? !string.equals(xmlURI) : n == 0) {
                    throw new DOMException(14, "DOM003 Namespace error");
                }
            }
        }
        this.namespaceURI = string;
    }

    protected ElementNSImpl(DocumentImpl documentImpl, String string) {
        super(documentImpl, string);
    }

    public String getNamespaceURI() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.namespaceURI;
    }

    public String getPrefix() {
        int n;
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return (n = this.name.indexOf(58)) < 0 ? null : this.name.substring(0, n);
    }

    public void setPrefix(String string) throws DOMException {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.ownerDocument().errorChecking) {
            if (this.isReadOnly()) {
                throw new DOMException(7, "DOM001 Modification not allowed");
            }
            if (!DocumentImpl.isXMLName(string)) {
                throw new DOMException(5, "DOM002 Illegal character");
            }
            if (this.namespaceURI == null) {
                throw new DOMException(14, "DOM003 Namespace error");
            }
            if (string != null && string.equals("xml") && !this.namespaceURI.equals(xmlURI)) {
                throw new DOMException(14, "DOM003 Namespace error");
            }
        }
        this.name = string + ":" + this.localName;
    }

    public String getLocalName() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.localName;
    }
}

