/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.instantdb.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Vector;
import org.enhydra.instantdb.db.Column;
import org.enhydra.instantdb.db.CurrencyColumn;
import org.enhydra.instantdb.db.StringColumn;
import org.enhydra.instantdb.db.Table;
import org.enhydra.instantdb.db.Trace;

public class idbResultSetMetaData
implements ResultSetMetaData {
    Table RStable;
    Column[] cols;

    idbResultSetMetaData(Table table) {
        this.RStable = table;
        Vector vector = this.RStable.getColList();
        this.cols = new Column[vector.size()];
        int n = 1;
        while (n < vector.size()) {
            this.cols[n] = (Column)vector.elementAt(n);
            ++n;
        }
    }

    public String getCatalogName(int n) throws SQLException {
        this.trace("getCatalogName");
        return "";
    }

    public String getColumnClassName(int n) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public int getColumnCount() throws SQLException {
        this.trace("getColumnCount");
        return this.RStable.getColCount() - 1;
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        Object object;
        int n2 = 0;
        switch (this.cols[n].getType()) {
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 9;
                break;
            }
            case 4: 
            case 8: {
                n2 = 15;
                break;
            }
            case 3: {
                object = (StringColumn)this.cols[n];
                n2 = ((StringColumn)object).getMaxWidth();
                break;
            }
            default: {
                n2 = 5;
            }
        }
        object = this.cols[n].getName();
        if (((String)object).length() > n2) {
            n2 = ((String)object).length();
        }
        this.trace("getColumnDisplaySize: " + this.cols[n].getName() + "=" + n2);
        return n2;
    }

    public String getColumnLabel(int n) throws SQLException {
        this.trace("getColumnLabel: " + this.cols[n].getName());
        return this.cols[n].getName();
    }

    public String getColumnName(int n) throws SQLException {
        this.trace("getColumnName");
        return this.cols[n].getName();
    }

    public int getColumnType(int n) throws SQLException {
        this.trace("getColumnType");
        return Column.SQL_TYPES[this.cols[n].getType()];
    }

    public String getColumnTypeName(int n) throws SQLException {
        this.trace("getColumnTypeName");
        return Column.typeNames[this.cols[n].getType()];
    }

    public int getPrecision(int n) throws SQLException {
        this.trace("getPrecision");
        switch (this.cols[n].getType()) {
            case 1: {
                return 3;
            }
            case 2: {
                return 10;
            }
            case 4: {
                return 19;
            }
            case 7: {
                return 7;
            }
            case 5: {
                return 19;
            }
            case 6: {
                return 19;
            }
            case 8: {
                return 15;
            }
            case 10: {
                return 65536;
            }
            case 3: {
                return (this.cols[n].getLength() - 4) / 2;
            }
        }
        return 0;
    }

    public int getScale(int n) throws SQLException {
        this.trace("getScale");
        return 0;
    }

    public String getSchemaName(int n) throws SQLException {
        this.trace("getSchemaName");
        return "";
    }

    public String getTableName(int n) throws SQLException {
        this.trace("getTableName");
        String string = "";
        Table table = this.cols[n].getUnderlyingTable();
        if (table != null) {
            string = table.getTableName();
        }
        return string;
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        this.trace("isAutoIncrement");
        return this.cols[n].isAutoIncrement();
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        this.trace("isCaseSensitive");
        return this.cols[n] instanceof StringColumn;
    }

    public boolean isCurrency(int n) throws SQLException {
        this.trace("isCurrency");
        return this.cols[n] instanceof CurrencyColumn;
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        this.trace("isDefinitelyWritable");
        return this.isWritable(n);
    }

    public int isNullable(int n) throws SQLException {
        this.trace("isNullable");
        if (this.cols[n].allowsNull()) {
            return 1;
        }
        return 0;
    }

    public boolean isReadOnly(int n) throws SQLException {
        this.trace("isReadOnly");
        return this.cols[n].isReadOnly();
    }

    public boolean isSearchable(int n) throws SQLException {
        this.trace("isSearchable");
        return true;
    }

    public boolean isSigned(int n) throws SQLException {
        this.trace("isSigned");
        return true;
    }

    public boolean isWritable(int n) throws SQLException {
        this.trace("isWritable");
        return this.isReadOnly(n) ^ true;
    }

    private void trace(String string) {
        if (Trace.traceIt(1024)) {
            Trace.traceOut(" RS Meta " + string);
        }
    }
}

