/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.instantdb.db;

class StringHashTable {
    String[] keys;
    Object[] values;
    int count;
    boolean[] lengthUsed;
    static int LENGTH_BITMAP_SIZE = 24;
    static boolean[] emptyFlags = new boolean[LENGTH_BITMAP_SIZE];

    StringHashTable(int n) {
        this.keys = new String[n];
        this.values = new Object[n];
        this.lengthUsed = new boolean[LENGTH_BITMAP_SIZE];
    }

    void clear() {
        int n = 0;
        while (n < this.count) {
            this.keys[n] = null;
            this.values[n] = null;
            ++n;
        }
        this.count = 0;
        System.arraycopy(emptyFlags, 0, this.lengthUsed, 0, LENGTH_BITMAP_SIZE);
    }

    int containsKey(String string) {
        int n = string.length();
        if (!this.lengthUsed[n]) {
            return -1;
        }
        int n2 = 0;
        while (n2 < this.count) {
            String string2 = this.keys[n2];
            if (string2 != null && n == string2.length() && string.equals(string2)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    Object get(String string) {
        if (this.count == 0) {
            return null;
        }
        int n = this.containsKey(string);
        if (n == -1) {
            return null;
        }
        return this.values[n];
    }

    void put(String string, Object object) {
        if (this.count == this.keys.length) {
            String[] stringArray = new String[this.count * 2];
            Object[] objectArray = new Object[this.count * 2];
            int n = 0;
            while (n < this.count) {
                stringArray[n] = this.keys[n];
                objectArray[n] = this.values[n];
                ++n;
            }
            this.keys = stringArray;
            this.values = objectArray;
        }
        this.keys[this.count] = string;
        this.values[this.count++] = object;
        this.lengthUsed[string.length()] = true;
    }

    void remove(String string) {
        int n = this.containsKey(string);
        if (n == -1) {
            return;
        }
        this.keys[n] = null;
        this.values[n] = null;
        if (n == this.count - 1) {
            --this.count;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.count * 10);
        stringBuffer.append('[');
        int n = 0;
        while (n < this.count) {
            if (this.keys[n] != null) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(' ');
                stringBuffer.append(this.keys[n]);
                stringBuffer.append('=');
                stringBuffer.append(this.values[n]);
            }
            ++n;
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

