/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteJava;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class Java
extends Task {
    private CommandlineJava cmdl = new CommandlineJava();
    private boolean fork = false;
    private File dir = null;
    private boolean failOnError = false;

    public void addSysproperty(Environment.Variable sysp) {
        this.cmdl.addSysproperty(sysp);
    }

    public void clearArgs() {
        this.cmdl.clearJavaArgs();
    }

    public Commandline.Argument createArg() {
        return this.cmdl.createArgument();
    }

    public Path createClasspath() {
        return this.cmdl.createClasspath(this.project).createPath();
    }

    public Commandline.Argument createJvmarg() {
        return this.cmdl.createVmArgument();
    }

    public void execute() throws BuildException {
        int err = -1;
        err = this.executeJava();
        if (err != 0) {
            if (this.failOnError) {
                throw new BuildException("Java returned: " + err, this.location);
            }
            this.log("Java Result: " + err, 0);
        }
    }

    public int executeJava() throws BuildException {
        String classname = this.cmdl.getClassname();
        if (classname == null) {
            throw new BuildException("Classname must not be null.");
        }
        if (this.fork) {
            this.log("Forking " + this.cmdl.toString(), 3);
            return this.run(this.cmdl.getCommandline());
        }
        if (this.cmdl.getVmCommand().size() > 1) {
            this.log("JVM args ignored when same JVM is used.", 1);
        }
        if (this.dir != null) {
            this.log("Working directory ignored when same JVM is used.", 1);
        }
        this.log("Running in same VM " + this.cmdl.getJavaCommand().toString(), 3);
        this.run(this.cmdl);
        return 0;
    }

    protected void run(String classname, Vector args) throws BuildException {
        CommandlineJava cmdj = new CommandlineJava();
        cmdj.setClassname(classname);
        int i = 0;
        while (i < args.size()) {
            cmdj.createArgument().setValue((String)args.elementAt(i));
            ++i;
        }
        this.run(cmdj);
    }

    private void run(CommandlineJava command) throws BuildException {
        ExecuteJava exe = new ExecuteJava();
        exe.setJavaCommand(command.getJavaCommand());
        exe.setClasspath(command.getClasspath());
        exe.setSystemProperties(command.getSystemProperties());
        exe.execute(this.project);
    }

    private int run(String[] command) throws BuildException {
        Execute exe = new Execute(new LogStreamHandler(this, 2, 1), null);
        exe.setAntRun(this.project);
        if (this.dir == null) {
            this.dir = this.project.getBaseDir();
        } else if (!this.dir.exists() || !this.dir.isDirectory()) {
            throw new BuildException(String.valueOf(this.dir.getAbsolutePath()) + " is not a valid directory", this.location);
        }
        exe.setWorkingDirectory(this.dir);
        exe.setCommandline(command);
        try {
            return exe.execute();
        }
        catch (IOException e) {
            throw new BuildException(e, this.location);
        }
    }

    public void setArgs(String s) {
        this.log("The args attribute is deprecated. Please use nested arg elements.", 1);
        this.cmdl.createArgument().setLine(s);
    }

    public void setClassname(String s) {
        this.cmdl.setClassname(s);
    }

    public void setClasspath(Path s) {
        this.createClasspath().append(s);
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void setDir(File d) {
        this.dir = d;
    }

    public void setFailonerror(boolean fail) {
        this.failOnError = fail;
    }

    public void setFork(boolean s) {
        this.fork = s;
    }

    public void setJvm(String s) {
        this.cmdl.setVm(s);
    }

    public void setJvmargs(String s) {
        this.log("The jvmargs attribute is deprecated. Please use nested jvmarg elements.", 1);
        this.cmdl.createVmArgument().setLine(s);
    }

    public void setMaxmemory(String max) {
        if (Project.getJavaVersion().startsWith("1.1")) {
            this.createJvmarg().setValue("-mx" + max);
        } else {
            this.createJvmarg().setValue("-Xmx" + max);
        }
    }
}

