/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.taglib.html;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Form;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorResources;
import org.apache.commons.validator.Var;
import org.apache.commons.validator.util.ValidatorUtils;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.taglib.TagUtils;
import org.apache.struts.util.MessageResources;
import org.apache.struts.validator.Resources;

public class JavascriptValidatorTag
extends BodyTagSupport {
    private static final Comparator actionComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            ValidatorAction va1 = (ValidatorAction)o1;
            ValidatorAction va2 = (ValidatorAction)o2;
            if (!(va1.getDepends() != null && va1.getDepends().length() != 0 || va2.getDepends() != null && va2.getDepends().length() != 0)) {
                return 0;
            }
            if (va1.getDepends() != null && va1.getDepends().length() > 0 && (va2.getDepends() == null || va2.getDepends().length() == 0)) {
                return 1;
            }
            if ((va1.getDepends() == null || va1.getDepends().length() == 0) && va2.getDepends() != null && va2.getDepends().length() > 0) {
                return -1;
            }
            return va1.getDependencyList().size() - va2.getDependencyList().size();
        }
    };
    protected static final String HTML_BEGIN_COMMENT = "\n<!-- Begin \n";
    protected static final String HTML_END_COMMENT = "//End --> \n";
    protected String bundle = "org.apache.struts.action.MESSAGE";
    protected static Locale defaultLocale = Locale.getDefault();
    protected String formName = null;
    protected String jsFormName = null;
    protected static String lineEnd = System.getProperty("line.separator");
    protected int page = 0;
    protected String methodName = null;
    protected boolean scriptLanguage = true;
    protected String staticJavascript = "true";
    protected String dynamicJavascript = "true";
    protected String src = null;
    protected String htmlComment = "true";
    protected String cdata = "true";

    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    public String getJsFormName() {
        return this.jsFormName;
    }

    public void setJsFormName(String jsFormName) {
        this.jsFormName = jsFormName;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public String getMethod() {
        return this.methodName;
    }

    public void setMethod(String methodName) {
        this.methodName = methodName;
    }

    public String getStaticJavascript() {
        return this.staticJavascript;
    }

    public void setStaticJavascript(String staticJavascript) {
        this.staticJavascript = staticJavascript;
    }

    public String getDynamicJavascript() {
        return this.dynamicJavascript;
    }

    public void setDynamicJavascript(String dynamicJavascript) {
        this.dynamicJavascript = dynamicJavascript;
    }

    public String getHtmlComment() {
        return this.htmlComment;
    }

    public void setHtmlComment(String htmlComment) {
        this.htmlComment = htmlComment;
    }

    public String getSrc() {
        return this.src;
    }

    public void setSrc(String src) {
        this.src = src;
    }

    public int doStartTag() throws JspException {
        JspWriter writer = this.pageContext.getOut();
        try {
            writer.print(this.renderJavascript());
        }
        catch (IOException e) {
            throw new JspException(e.getMessage());
        }
        return 2;
    }

    protected String renderJavascript() throws JspException {
        StringBuffer results = new StringBuffer();
        ModuleConfig config = TagUtils.getInstance().getModuleConfig(this.pageContext);
        ValidatorResources resources = (ValidatorResources)this.pageContext.getAttribute("org.apache.commons.validator.VALIDATOR_RESOURCES" + config.getPrefix(), 4);
        Locale locale = TagUtils.getInstance().getUserLocale(this.pageContext, null);
        Form form = resources.getForm(locale, this.formName);
        if ("true".equalsIgnoreCase(this.dynamicJavascript) && form == null) {
            throw new JspException("No form found under '" + this.formName + "' in locale '" + locale + "'");
        }
        if (form != null) {
            if ("true".equalsIgnoreCase(this.dynamicJavascript)) {
                results.append(this.createDynamicJavascript(config, resources, locale, form));
            } else if ("true".equalsIgnoreCase(this.staticJavascript)) {
                results.append(this.renderStartElement());
                if ("true".equalsIgnoreCase(this.htmlComment)) {
                    results.append(HTML_BEGIN_COMMENT);
                }
            }
        }
        if ("true".equalsIgnoreCase(this.staticJavascript)) {
            results.append(this.getJavascriptStaticMethods(resources));
        }
        if (form != null && ("true".equalsIgnoreCase(this.dynamicJavascript) || "true".equalsIgnoreCase(this.staticJavascript))) {
            results.append(this.getJavascriptEnd());
        }
        return results.toString();
    }

    private String createDynamicJavascript(ModuleConfig config, ValidatorResources resources, Locale locale, Form form) throws JspException {
        String formName;
        StringBuffer results = new StringBuffer();
        MessageResources messages = (MessageResources)this.pageContext.getAttribute(this.bundle + config.getPrefix(), 4);
        List actions = this.createActionList(resources, form);
        String methods = this.createMethods(actions, this.stopOnError(config));
        this.jsFormName = formName = form.getName();
        if (this.jsFormName.charAt(0) == '/') {
            String mappingName = TagUtils.getInstance().getActionMappingName(this.jsFormName);
            ActionMapping mapping = (ActionMapping)config.findActionConfig(mappingName);
            if (mapping == null) {
                JspException e = new JspException(messages.getMessage("formTag.mapping", (Object)mappingName));
                this.pageContext.setAttribute("org.apache.struts.action.EXCEPTION", (Object)e, 2);
                throw e;
            }
            this.jsFormName = mapping.getAttribute();
        }
        results.append(this.getJavascriptBegin(methods));
        Iterator i = actions.iterator();
        while (i.hasNext()) {
            ValidatorAction va = (ValidatorAction)i.next();
            int jscriptVar = 0;
            String functionName = null;
            functionName = va.getJsFunctionName() != null && va.getJsFunctionName().length() > 0 ? va.getJsFunctionName() : va.getName();
            results.append("    function " + this.jsFormName + "_" + functionName + " () { \n");
            Iterator x = form.getFields().iterator();
            while (x.hasNext()) {
                Field field = (Field)x.next();
                if (field.isIndexed() || field.getPage() != this.page || !field.isDependency(va.getName())) continue;
                String message = Resources.getMessage(messages, locale, va, field);
                message = message != null ? message : "";
                results.append("     this.a" + jscriptVar++ + " = new Array(\"" + field.getKey() + "\", \"" + this.escapeQuotes(message) + "\", ");
                results.append("new Function (\"varName\", \"");
                Map vars = field.getVars();
                Iterator varsIterator = vars.keySet().iterator();
                while (varsIterator.hasNext()) {
                    String varName = (String)varsIterator.next();
                    Var var = (Var)vars.get(varName);
                    String varValue = var.getValue();
                    String jsType = var.getJsType();
                    if (varName.startsWith("field")) continue;
                    if ("int".equalsIgnoreCase(jsType)) {
                        results.append("this." + varName + "=" + ValidatorUtils.replace((String)varValue, (String)"\\", (String)"\\\\") + "; ");
                        continue;
                    }
                    if ("regexp".equalsIgnoreCase(jsType)) {
                        results.append("this." + varName + "=/" + ValidatorUtils.replace((String)varValue, (String)"\\", (String)"\\\\") + "/; ");
                        continue;
                    }
                    if ("string".equalsIgnoreCase(jsType)) {
                        results.append("this." + varName + "='" + ValidatorUtils.replace((String)varValue, (String)"\\", (String)"\\\\") + "'; ");
                        continue;
                    }
                    if ("mask".equalsIgnoreCase(varName)) {
                        results.append("this." + varName + "=/" + ValidatorUtils.replace((String)varValue, (String)"\\", (String)"\\\\") + "/; ");
                        continue;
                    }
                    results.append("this." + varName + "='" + ValidatorUtils.replace((String)varValue, (String)"\\", (String)"\\\\") + "'; ");
                }
                results.append(" return this[varName];\"));\n");
            }
            results.append("    } \n\n");
        }
        return results.toString();
    }

    private String escapeQuotes(String in) {
        if (in == null || in.indexOf("\"") == -1) {
            return in;
        }
        StringBuffer buffer = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(in, "\"", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("\"")) {
                buffer.append("\\");
            }
            buffer.append(token);
        }
        return buffer.toString();
    }

    private boolean stopOnError(ModuleConfig config) {
        Object stopOnErrorObj = this.pageContext.getAttribute("org.apache.struts.validator.STOP_ON_ERROR." + config.getPrefix(), 4);
        boolean stopOnError = true;
        if (stopOnErrorObj instanceof Boolean) {
            stopOnError = (Boolean)stopOnErrorObj;
        }
        return stopOnError;
    }

    private String createMethods(List actions, boolean stopOnError) {
        StringBuffer methods = new StringBuffer();
        String methodOperator = stopOnError ? " && " : " & ";
        Iterator iter = actions.iterator();
        while (iter.hasNext()) {
            ValidatorAction va = (ValidatorAction)iter.next();
            if (methods.length() > 0) {
                methods.append(methodOperator);
            }
            methods.append(va.getMethod()).append("(form)");
        }
        return methods.toString();
    }

    private List createActionList(ValidatorResources resources, Form form) {
        ArrayList actionMethods = new ArrayList();
        Iterator iterator = form.getFields().iterator();
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            Iterator x = field.getDependencyList().iterator();
            while (x.hasNext()) {
                Object o = x.next();
                if (o == null || actionMethods.contains(o)) continue;
                actionMethods.add(o);
            }
        }
        ArrayList<ValidatorAction> actions = new ArrayList<ValidatorAction>();
        iterator = actionMethods.iterator();
        while (iterator.hasNext()) {
            String depends = (String)iterator.next();
            ValidatorAction va = resources.getValidatorAction(depends);
            if (va == null) {
                throw new NullPointerException("Depends string \"" + depends + "\" was not found in validator-rules.xml.");
            }
            if (va.getJavascript() != null && va.getJavascript().length() > 0) {
                actions.add(va);
                continue;
            }
            iterator.remove();
        }
        Collections.sort(actions, actionComparator);
        return actions;
    }

    public void release() {
        super.release();
        this.bundle = "org.apache.struts.action.MESSAGE";
        this.formName = null;
        this.jsFormName = null;
        this.page = 0;
        this.methodName = null;
        this.staticJavascript = "true";
        this.dynamicJavascript = "true";
        this.htmlComment = "true";
        this.cdata = "true";
        this.src = null;
    }

    protected String getJavascriptBegin(String methods) {
        StringBuffer sb = new StringBuffer();
        String name = this.jsFormName.replace('/', '_');
        name = this.jsFormName.substring(0, 1).toUpperCase() + this.jsFormName.substring(1, this.jsFormName.length());
        sb.append(this.renderStartElement());
        if (this.isXhtml() && "true".equalsIgnoreCase(this.cdata)) {
            sb.append("<![CDATA[\r\n");
        }
        if (!this.isXhtml() && "true".equals(this.htmlComment)) {
            sb.append(HTML_BEGIN_COMMENT);
        }
        sb.append("\n     var bCancel = false; \n\n");
        if (this.methodName == null || this.methodName.length() == 0) {
            sb.append("    function validate" + name + "(form) {                                                                   \n");
        } else {
            sb.append("    function " + this.methodName + "(form) {                                                                   \n");
        }
        sb.append("        if (bCancel) \n");
        sb.append("      return true; \n");
        sb.append("        else \n");
        if (methods == null || methods.length() == 0) {
            sb.append("       return true; \n");
        } else {
            sb.append(" var formValidationResult;\n");
            sb.append("       formValidationResult = " + methods + "; \n");
            sb.append("     return (formValidationResult == 1);\n");
        }
        sb.append("   } \n\n");
        return sb.toString();
    }

    protected String getJavascriptStaticMethods(ValidatorResources resources) {
        StringBuffer sb = new StringBuffer();
        sb.append("\n\n");
        Iterator actions = resources.getValidatorActions().values().iterator();
        while (actions.hasNext()) {
            String javascript;
            ValidatorAction va = (ValidatorAction)actions.next();
            if (va == null || (javascript = va.getJavascript()) == null || javascript.length() <= 0) continue;
            sb.append(javascript + "\n");
        }
        return sb.toString();
    }

    protected String getJavascriptEnd() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n");
        if (!this.isXhtml() && "true".equals(this.htmlComment)) {
            sb.append(HTML_END_COMMENT);
        }
        if (this.isXhtml() && "true".equalsIgnoreCase(this.cdata)) {
            sb.append("]]>\r\n");
        }
        sb.append("</script>\n\n");
        return sb.toString();
    }

    protected String renderStartElement() {
        StringBuffer start = new StringBuffer("<script type=\"text/javascript\"");
        if (!this.isXhtml() && this.scriptLanguage) {
            start.append(" language=\"Javascript1.1\"");
        }
        if (this.src != null) {
            start.append(" src=\"" + this.src + "\"");
        }
        start.append("> \n");
        return start.toString();
    }

    private boolean isXhtml() {
        return TagUtils.getInstance().isXhtml(this.pageContext);
    }

    public String getCdata() {
        return this.cdata;
    }

    public void setCdata(String cdata) {
        this.cdata = cdata;
    }

    public boolean getScriptLanguage() {
        return this.scriptLanguage;
    }

    public void setScriptLanguage(boolean scriptLanguage) {
        this.scriptLanguage = scriptLanguage;
    }
}

