/*
 * Decompiled with CFR 0.152.
 */
package test.pdfbox.filter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.filter.CCITTFaxDecodeFilter;
import org.pdfbox.filter.DCTFilter;
import org.pdfbox.filter.Filter;
import org.pdfbox.filter.FilterManager;
import org.pdfbox.filter.RunLengthDecodeFilter;

public class TestFilters
extends TestCase {
    private static final int BUFFER_SIZE = 2048;
    private static final COSDictionary EMPTY_DICTIONARY = new COSDictionary();
    static /* synthetic */ Class class$test$pdfbox$filter$TestFilters;

    public TestFilters(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(class$test$pdfbox$filter$TestFilters == null ? (class$test$pdfbox$filter$TestFilters = TestFilters.class$("test.pdfbox.filter.TestFilters")) : class$test$pdfbox$filter$TestFilters);
    }

    public void testFilters() throws IOException {
        FilterManager manager = new FilterManager();
        Collection filters = manager.getFilters();
        Iterator filterIter = filters.iterator();
        while (filterIter.hasNext()) {
            long start = System.currentTimeMillis();
            Filter filter = (Filter)filterIter.next();
            if (filter instanceof DCTFilter || filter instanceof CCITTFaxDecodeFilter || filter instanceof RunLengthDecodeFilter) continue;
            this.checkFilter(new File("classes"), filter);
            long stop = System.currentTimeMillis();
            System.out.println("Time for filter " + filter.getClass().getName() + "=" + (stop - start));
        }
    }

    private void checkFilter(File file, Filter filter) throws IOException {
        if (file.isDirectory()) {
            File[] subFiles = file.listFiles();
            for (int i = 0; i < subFiles.length; ++i) {
                this.checkFilter(subFiles[i], filter);
            }
        } else {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            ByteArrayOutputStream encoded = new ByteArrayOutputStream();
            ByteArrayOutputStream decoded = new ByteArrayOutputStream();
            FileInputStream fin = new FileInputStream(file);
            int amountRead = 0;
            byte[] buffer = new byte[2048];
            while ((amountRead = fin.read(buffer, 0, 2048)) != -1) {
                output.write(buffer, 0, amountRead);
            }
            fin.close();
            byte[] original = output.toByteArray();
            filter.encode(new ByteArrayInputStream(original), encoded, EMPTY_DICTIONARY);
            filter.decode(new ByteArrayInputStream(encoded.toByteArray()), decoded, EMPTY_DICTIONARY);
            this.cmpArray(original, decoded.toByteArray(), filter, file);
        }
    }

    private void cmpArray(byte[] firstArray, byte[] secondArray, Filter filter, File file) {
        String fileMsg = filter.getClass().getName() + " " + file.getAbsolutePath();
        if (firstArray.length != secondArray.length) {
            TestFilters.fail((String)("The array lengths do not match for " + fileMsg + ", firstArray length was: " + firstArray.length + ", secondArray length was: " + secondArray.length));
        }
        for (int i = 0; i < firstArray.length; ++i) {
            if (firstArray[i] == secondArray[i]) continue;
            TestFilters.fail((String)("Array data does not match " + fileMsg));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

