/* ImportGraphList.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.main.actions;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.grinvin.worksheet.WorksheetWindow;
import org.grinvin.worksheet.WorksheetWindowModel;
import org.grinvin.gui.FileFilters;
import org.grinvin.main.GrinvinWindow;
import org.grinvin.io.graphs.Graph6Loader;
import org.grinvin.io.list.GraphListLoader;

import be.ugent.caagt.swirl.actions.FileOpenAction;

/**
 * Action to import a graph list from a file.
 */
public class ImportGraphList extends FileOpenAction {

    //
    private static final Logger LOGGER = Logger.getLogger("org.grinvin.io");
    //
    private final GrinvinWindow grinvinWindow;

    public ImportGraphList(GrinvinWindow grinvinWindow) {
        super(grinvinWindow, false, FileFilters.GRAPHLIST_FILTER, FileFilters.G6_LIST_FILTER);
        this.grinvinWindow = grinvinWindow;
    // [kc] cannot yet retrieve the worksheet list model at this time
    }

    // implements performOpen
    public void openFile(File file) {

        try {
            WorksheetWindowModel model = new WorksheetWindowModel();
            if (FileFilters.GRAPHLIST_FILTER.accept(file)) {
                GraphListLoader.load(model.getGraphList(), new FileInputStream(file), null);
            } else if (FileFilters.G6_LIST_FILTER.accept(file)) {
                Graph6Loader.readFile(model.getGraphList(), file);
                model.setName(file.getName());
            } else {
                throw new RuntimeException("Unexpected file type: " + file);
            }
            WorksheetWindow window = new WorksheetWindow(model);
            window.setVisible(true);
            grinvinWindow.getWorksheetListModel().getWorksheetWindowListModel().add(window);
        } catch (IOException e) {
            //TODO: message the user
            LOGGER.log(Level.INFO, "Failed to import graph list", e);
        }
    }
}
